/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.IGhostAgent;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004GetBackToNavGraph;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004RunStraight;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.KefikRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.LoqueNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004DistanceStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004Navigation {
    protected LogCategory log;
    protected UT2004PathExecutor<ILocated> pathExecutor;
    protected FloydWarshallMap fwMap;
    protected UT2004Bot bot;
    protected UT2004GetBackToNavGraph getBackToNavGraph;
    protected UT2004RunStraight runStraight;
    protected static final int NEW_PATH_DISTANCE_THRESHOLD = 40;
    protected static final int ARRIVED_AT_LOCATION_XY_THRESHOLD = 50;
    protected static final int ARRIVED_AT_LOCATION_Z_THRESHOLD = 100;
    protected static final double PLAYER_DISTANCE_TRASHOLD = 600.0;
    public static final double AT_PLAYER = 100.0;
    FlagListener<IPathExecutorState> myUT2004PathExecutorStateListener = new FlagListener<IPathExecutorState>(){

        public void flagChanged(IPathExecutorState changedValue) {
            switch (changedValue.getState()) {
                case TARGET_REACHED: {
                    UT2004Navigation.this.targetReached();
                    break;
                }
                case PATH_COMPUTATION_FAILED: 
                case STUCK: {
                    UT2004Navigation.this.stuck();
                }
            }
        }
    };
    protected IWorldEventListener<EndMessage> endMessageListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            UT2004Navigation.this.navigate();
        }
    };
    protected ILocated lastTarget = null;
    protected Player lastTargetPlayer = null;
    protected ILocated currentTarget = null;
    protected Player currentTargetPlayer = null;
    protected NavPoint fromNavPoint;
    protected NavPoint toNavPoint;
    protected IPathFuture currentFuturePath;
    protected boolean navigating = false;
    protected boolean runningStraightToPlayer = false;
    protected Location runningStraightToPlayerFailedAt = null;

    public UT2004Navigation(UT2004Bot bot, UT2004PathExecutor ut2004PathExecutor, FloydWarshallMap fwMap, UT2004GetBackToNavGraph getBackOnPath, UT2004RunStraight runStraight) {
        this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        this.bot = bot;
        this.fwMap = fwMap;
        this.pathExecutor = ut2004PathExecutor;
        this.getBackToNavGraph = getBackOnPath;
        this.runStraight = runStraight;
        this.initListeners();
    }

    public UT2004Navigation(UT2004Bot bot, AgentInfo info, AdvancedLocomotion move) {
        this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        this.bot = bot;
        this.fwMap = new FloydWarshallMap((IGhostAgent)bot);
        this.pathExecutor = new UT2004PathExecutor(bot, new LoqueNavigator(bot, new KefikRunner(bot, info, move, (Logger)bot.getLog()), (Logger)bot.getLog()));
        this.pathExecutor.addStuckDetector(new UT2004TimeStuckDetector(bot, 3000.0, 100000.0));
        this.pathExecutor.addStuckDetector(new UT2004PositionStuckDetector(bot));
        this.pathExecutor.addStuckDetector(new UT2004DistanceStuckDetector(bot));
        this.getBackToNavGraph = new UT2004GetBackToNavGraph(bot, info, move);
        this.runStraight = new UT2004RunStraight(bot, info, move);
        this.initListeners();
    }

    private void initListeners() {
        this.pathExecutor.getState().addListener(this.myUT2004PathExecutorStateListener);
        this.bot.getWorldView().addEventListener(EndMessage.class, this.endMessageListener);
    }

    public boolean isNavigating() {
        return this.pathExecutor.isExecuting();
    }

    public void setFocus(ILocated located) {
        this.pathExecutor.setFocus(located);
        this.getBackToNavGraph.setFocus(located);
        this.runStraight.setFocus(located);
    }

    public void stopNavigation() {
        this.reset(true);
    }

    public void navigate(ILocated target) {
        if (target == null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Cannot navigate to NULL target!");
            }
            return;
        }
        if (target instanceof Player) {
            this.navigate((Player)target);
            return;
        }
        if (this.navigating) {
            if (this.currentTarget == target || this.currentTarget.getLocation().equals(target.getLocation())) {
                return;
            }
            this.reset(false);
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Start navigating to: " + target);
        }
        this.navigating = true;
        this.currentTarget = target;
        this.navigate();
    }

    public void navigate(Player player) {
        if (player == null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Cannot navigate to NULL player!");
            }
            return;
        }
        if (this.navigating) {
            if (this.currentTarget == player) {
                return;
            }
            this.reset(false);
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Start pursuing: " + player);
        }
        this.navigating = true;
        this.currentTarget = player.getLocation();
        this.currentTargetPlayer = player;
        this.navigate();
    }

    public NavPoint getNearestNavPoint(ILocated location) {
        if (location instanceof NavPoint) {
            return (NavPoint)location;
        }
        if (location instanceof Item && ((Item)location).getNavPoint() != null) {
            return ((Item)location).getNavPoint();
        }
        return (NavPoint)DistanceUtils.getNearest(this.bot.getWorldView().getAll(NavPoint.class).values(), (ILocated)location);
    }

    public List<ILocated> getCurrentPathCopy() {
        ArrayList<ILocated> result = new ArrayList<ILocated>();
        if (this.currentFuturePath != null) {
            result.addAll(this.currentFuturePath.get());
        }
        return result;
    }

    public List<ILocated> getCurrentPathDirect() {
        if (this.currentFuturePath != null) {
            return this.currentFuturePath.get();
        }
        return null;
    }

    public ILocated getCurrentTarget() {
        return this.currentTarget;
    }

    public Player getCurrentTargetPlayer() {
        return this.currentTargetPlayer;
    }

    public ILocated getLastTarget() {
        return this.lastTarget;
    }

    public ILocated getLastTargetPlayer() {
        return this.lastTarget;
    }

    protected void navigate() {
        if (!this.navigating) {
            return;
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("NAVIGATING");
        }
        if (this.currentTargetPlayer != null) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Pursuing " + this.currentTargetPlayer);
            }
            this.navigatePlayer();
        } else {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Navigating to " + this.currentTarget);
            }
            this.navigateLocation();
        }
    }

    private void navigateLocation() {
        if (this.pathExecutor.isExecuting()) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Path executor running");
            }
            return;
        }
        if (!this.getBackToNavGraph.isOnNavGraph()) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Getting back to navigation graph");
            }
            this.getBackToNavGraph.execute();
            return;
        }
        this.fromNavPoint = this.getNearestNavPoint((ILocated)this.bot.getLocation());
        this.toNavPoint = this.getNearestNavPoint(this.currentTarget);
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Running from " + this.fromNavPoint.getId().getStringId() + " to " + this.toNavPoint.getId().getStringId());
        }
        this.currentFuturePath = this.fwMap.computePath(this.fromNavPoint, this.toNavPoint);
        this.processPathFuture(this.currentFuturePath);
        this.pathExecutor.followPath(this.currentFuturePath);
    }

    private void navigatePlayer() {
        double vDistance = this.bot.getLocation().getDistanceZ(this.currentTargetPlayer.getLocation());
        double hDistance = this.bot.getLocation().getDistance2D(this.currentTargetPlayer.getLocation());
        if (hDistance < 100.0 && vDistance < 50.0) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Player reached");
            }
            if (this.pathExecutor.isExecuting()) {
                this.pathExecutor.getPath().set(this.pathExecutor.getPath().size() - 1, this.bot.getLocation());
            } else {
                this.targetReached();
            }
            return;
        }
        if (hDistance < 400.0 && Math.abs(vDistance) < 50.0) {
            if (this.runningStraightToPlayer) {
                if (this.runStraight.isFailed()) {
                    this.runningStraightToPlayer = false;
                    this.runningStraightToPlayerFailedAt = this.bot.getLocation();
                }
            } else if (this.runningStraightToPlayerFailedAt == null || this.bot.getLocation().getDistance(this.runningStraightToPlayerFailedAt) > 500.0) {
                if (this.getBackToNavGraph.isExecuting()) {
                    this.getBackToNavGraph.stop();
                }
                if (this.pathExecutor.isExecuting()) {
                    this.pathExecutor.stop();
                }
                this.runningStraightToPlayer = true;
                this.runStraight.runStraight(this.currentTargetPlayer);
            }
            if (this.runningStraightToPlayer) {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Running straight to player");
                }
                return;
            }
        } else if (this.runningStraightToPlayer) {
            this.runningStraightToPlayer = false;
            this.runStraight.stop();
        }
        if (this.pathExecutor.isExecuting()) {
            double distance;
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Path executor running");
            }
            if ((distance = this.currentTarget.getLocation().getDistance(this.currentTargetPlayer.getLocation())) > 600.0) {
                NavPoint newToNavPoint;
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Player moved " + distance + " from its original location, checking path...");
                }
                if ((newToNavPoint = this.getNearestNavPoint(this.currentTargetPlayer)) != this.toNavPoint) {
                    ILocated currentlyRunningTo;
                    if (this.log != null && this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Replanning path to get to " + this.currentTargetPlayer);
                    }
                    if ((currentlyRunningTo = (ILocated)this.pathExecutor.getPathElement()) == null) {
                        currentlyRunningTo = this.bot.getLocation();
                    }
                    this.fromNavPoint = this.getNearestNavPoint(currentlyRunningTo);
                    this.toNavPoint = newToNavPoint;
                    this.currentTarget = this.currentTargetPlayer.getLocation();
                    this.currentFuturePath = this.fwMap.computePath(this.fromNavPoint, this.toNavPoint);
                    this.processPathFuture(this.currentFuturePath);
                    this.pathExecutor.followPath(this.currentFuturePath);
                } else if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Path remains the same");
                }
            }
            return;
        }
        if (!this.getBackToNavGraph.isOnNavGraph()) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Getting back to navigation graph");
            }
            this.getBackToNavGraph.execute();
            return;
        }
        this.fromNavPoint = this.getNearestNavPoint((ILocated)this.bot.getLocation());
        this.toNavPoint = this.getNearestNavPoint(this.currentTarget);
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Running from " + this.fromNavPoint.getId().getStringId() + " to " + this.toNavPoint.getId().getStringId());
        }
        this.currentFuturePath = this.fwMap.computePath(this.fromNavPoint, this.toNavPoint);
        this.processPathFuture(this.currentFuturePath);
        this.pathExecutor.followPath(this.currentFuturePath);
    }

    protected void processPathFuture(IPathFuture futurePath) {
        List pathList = futurePath.get();
        if (pathList == null) {
            return;
        }
        if (!pathList.isEmpty()) {
            ILocated lastPathElement = (ILocated)pathList.get(pathList.size() - 1);
            if (lastPathElement.getLocation().getDistance(this.currentTarget.getLocation()) > 40.0) {
                this.currentFuturePath.get().add(this.currentTarget);
            }
        } else {
            this.currentFuturePath.get().add(this.currentTarget);
        }
    }

    protected void stuck() {
        this.reset(true);
    }

    protected void targetReached() {
        this.reset(true);
    }

    protected void reset(boolean stopGetBackToNavGraph) {
        if (this.currentTarget != null) {
            this.lastTarget = this.currentTarget;
            this.lastTargetPlayer = this.currentTargetPlayer;
        }
        this.navigating = false;
        this.currentTarget = null;
        this.currentTargetPlayer = null;
        this.fromNavPoint = null;
        this.toNavPoint = null;
        this.currentFuturePath = null;
        this.runningStraightToPlayer = false;
        this.runningStraightToPlayerFailedAt = null;
        this.pathExecutor.stop();
        this.runStraight.stop();
        if (stopGetBackToNavGraph) {
            this.getBackToNavGraph.stop();
        }
    }

    public void addStrongNavigationListener(FlagListener<IPathExecutorState> listener) {
        this.pathExecutor.getState().addStrongListener(listener);
    }

    public void removeStrongNavigationListener(FlagListener<IPathExecutorState> listener) {
        this.pathExecutor.getState().removeListener(listener);
    }

    public List<IStuckDetector> getStuckDetectors() {
        return this.pathExecutor.getStuckDetectors();
    }

    public void addStuckDetector(IStuckDetector stuckDetector) {
        this.pathExecutor.addStuckDetector(stuckDetector);
    }

    public void removeStuckDetector(IStuckDetector stuckDetector) {
        this.pathExecutor.removeStuckDetector(stuckDetector);
    }
}

