/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ICompositeWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ILocalWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.IStaticWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.BooleanProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.LocationProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.PropertyId;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemLocal;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemLocalImpl;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemShared;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemSharedImpl;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemStatic;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemStaticImpl;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ItemDescriptor;
import cz.cuni.amis.utils.AdvancedEquals;
import cz.cuni.amis.utils.SafeEquals;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.HashMap;
import java.util.Map;

public class ItemMessage
extends Item
implements IWorldObjectUpdatedEvent,
ICompositeWorldObjectUpdatedEvent {
    protected ITeamId TeamId;
    protected UnrealId Id = null;
    protected UnrealId NavPointId = null;
    protected NavPoint NavPoint = null;
    protected boolean Visible = false;
    protected Location Location = null;
    protected boolean Reachable = false;
    protected int Amount = 0;
    protected ItemType Type = null;
    protected ItemDescriptor Descriptor = null;
    protected boolean Dropped = false;
    private ItemLocal localPart = null;
    private ItemShared sharedPart = null;
    private ItemStatic staticPart = null;

    public ItemMessage() {
    }

    public ItemMessage(UnrealId Id, UnrealId NavPointId, NavPoint NavPoint2, boolean Visible, Location Location2, boolean Reachable2, int Amount, ItemType Type2, ItemDescriptor Descriptor, boolean Dropped) {
        this.Id = Id;
        this.NavPointId = NavPointId;
        this.NavPoint = NavPoint2;
        this.Visible = Visible;
        this.Location = Location2;
        this.Reachable = Reachable2;
        this.Amount = Amount;
        this.Type = Type2;
        this.Descriptor = Descriptor;
        this.Dropped = Dropped;
    }

    public ItemMessage(ItemMessage original) {
        this.Id = original.getId();
        this.NavPointId = original.getNavPointId();
        this.NavPoint = original.getNavPoint();
        this.Visible = original.isVisible();
        this.Location = original.getLocation();
        this.Reachable = original.isReachable();
        this.Amount = original.getAmount();
        this.Type = original.getType();
        this.Descriptor = original.getDescriptor();
        this.Dropped = original.isDropped();
        this.TeamId = original.getTeamId();
        this.SimTime = original.getSimTime();
    }

    protected void setTeamId(ITeamId TeamId) {
        this.TeamId = TeamId;
    }

    public ITeamId getTeamId() {
        return this.TeamId;
    }

    @Override
    public UnrealId getId() {
        return this.Id;
    }

    @Override
    public UnrealId getNavPointId() {
        return this.NavPointId;
    }

    @Override
    public NavPoint getNavPoint() {
        return this.NavPoint;
    }

    @Override
    public boolean isVisible() {
        return this.Visible;
    }

    @Override
    public Location getLocation() {
        return this.Location;
    }

    @Override
    public boolean isReachable() {
        return this.Reachable;
    }

    @Override
    public int getAmount() {
        return this.Amount;
    }

    @Override
    public ItemType getType() {
        return this.Type;
    }

    @Override
    public ItemDescriptor getDescriptor() {
        return this.Descriptor;
    }

    @Override
    public boolean isDropped() {
        return this.Dropped;
    }

    public ItemLocal getLocal() {
        if (this.localPart != null) {
            return this.localPart;
        }
        this.localPart = new ItemLocalMessage();
        return this.localPart;
    }

    public ItemShared getShared() {
        if (this.sharedPart != null) {
            return this.sharedPart;
        }
        this.sharedPart = new ItemSharedMessage();
        return this.sharedPart;
    }

    public ItemStatic getStatic() {
        if (this.staticPart != null) {
            return this.staticPart;
        }
        this.staticPart = new ItemStaticMessage();
        return this.staticPart;
    }

    public IWorldObjectUpdateResult<IWorldObject> update(IWorldObject object) {
        if (object == null) {
            return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.CREATED, (IWorldObject)this);
        }
        if (!(object instanceof ItemMessage)) {
            throw new PogamutException("Can't update different class than ItemMessage, got class " + object.getClass().getSimpleName() + "!", (Object)this);
        }
        ItemMessage toUpdate = (ItemMessage)object;
        boolean updated = false;
        if (toUpdate.Visible != this.isVisible()) {
            toUpdate.Visible = this.isVisible();
            updated = true;
        }
        if (toUpdate.Reachable != this.isReachable()) {
            toUpdate.Reachable = this.isReachable();
            updated = true;
        }
        if (!SafeEquals.equals((Object)toUpdate.Location, (Object)this.getLocation())) {
            toUpdate.Location = this.getLocation();
            updated = true;
        }
        if (toUpdate.Dropped != this.isDropped()) {
            toUpdate.Dropped = this.isDropped();
            updated = true;
        }
        toUpdate.SimTime = this.SimTime;
        if (updated) {
            return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.UPDATED, (IWorldObject)toUpdate);
        }
        return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.SAME, (IWorldObject)toUpdate);
    }

    public ILocalWorldObjectUpdatedEvent getLocalEvent() {
        return new ItemLocalImpl.ItemLocalUpdate(this.getLocal(), this.SimTime);
    }

    public ISharedWorldObjectUpdatedEvent getSharedEvent() {
        return new ItemSharedImpl.ItemSharedUpdate(this.getShared(), this.SimTime, this.getTeamId());
    }

    public IStaticWorldObjectUpdatedEvent getStaticEvent() {
        return new ItemStaticImpl.ItemStaticUpdate(this.getStatic(), this.SimTime);
    }

    @Override
    public String toString() {
        return super.toString() + "[" + "Id = " + String.valueOf(this.getId()) + " | " + "NavPointId = " + String.valueOf(this.getNavPointId()) + " | " + "Visible = " + String.valueOf(this.isVisible()) + " | " + "Location = " + String.valueOf(this.getLocation()) + " | " + "Reachable = " + String.valueOf(this.isReachable()) + " | " + "Amount = " + String.valueOf(this.getAmount()) + " | " + "Type = " + String.valueOf(this.getType()) + " | " + "Dropped = " + String.valueOf(this.isDropped()) + " | " + "]";
    }

    @Override
    public String toHtmlString() {
        return super.toString() + "[<br/>" + "<b>Id</b> = " + String.valueOf(this.getId()) + " <br/> " + "<b>NavPointId</b> = " + String.valueOf(this.getNavPointId()) + " <br/> " + "<b>Visible</b> = " + String.valueOf(this.isVisible()) + " <br/> " + "<b>Location</b> = " + String.valueOf(this.getLocation()) + " <br/> " + "<b>Reachable</b> = " + String.valueOf(this.isReachable()) + " <br/> " + "<b>Amount</b> = " + String.valueOf(this.getAmount()) + " <br/> " + "<b>Type</b> = " + String.valueOf(this.getType()) + " <br/> " + "<b>Dropped</b> = " + String.valueOf(this.isDropped()) + " <br/> " + "<br/>]";
    }

    public void setNavPoint(NavPoint navPoint) {
        this.NavPoint = navPoint;
    }

    public class ItemSharedMessage
    extends ItemShared {
        protected HashMap<PropertyId, ISharedProperty> propertyMap = new HashMap(2);
        protected LocationProperty myLocation;
        protected BooleanProperty myDropped;

        public ItemSharedMessage() {
            this.myLocation = new LocationProperty((WorldObjectId)this.getId(), "Location", ItemMessage.this.Location, Item.class);
            this.myDropped = new BooleanProperty((WorldObjectId)this.getId(), "Dropped", Boolean.valueOf(ItemMessage.this.Dropped), Item.class);
            this.propertyMap.put(this.myLocation.getPropertyId(), (ISharedProperty)this.myLocation);
            this.propertyMap.put(this.myDropped.getPropertyId(), (ISharedProperty)this.myDropped);
        }

        @Override
        public ItemSharedMessage clone() {
            return this;
        }

        public ISharedProperty getProperty(PropertyId id) {
            return this.propertyMap.get(id);
        }

        public Map<PropertyId, ISharedProperty> getProperties() {
            return this.propertyMap;
        }

        @Override
        public UnrealId getId() {
            return ItemMessage.this.Id;
        }

        @Override
        public Location getLocation() {
            return (Location)this.myLocation.getValue();
        }

        @Override
        public boolean isDropped() {
            return (Boolean)this.myDropped.getValue();
        }

        @Override
        public String toString() {
            return super.toString() + "[" + "Id = " + String.valueOf(this.getId()) + " | " + "Location = " + String.valueOf(this.getLocation()) + " | " + "Dropped = " + String.valueOf(this.isDropped()) + " | " + "]";
        }

        @Override
        public String toHtmlString() {
            return super.toString() + "[<br/>" + "<b>Id</b> = " + String.valueOf(this.getId()) + " <br/> " + "<b>Location</b> = " + String.valueOf(this.getLocation()) + " <br/> " + "<b>Dropped</b> = " + String.valueOf(this.isDropped()) + " <br/> " + "<br/>]";
        }
    }

    public class ItemStaticMessage
    extends ItemStatic {
        @Override
        public ItemStaticMessage clone() {
            return this;
        }

        @Override
        public UnrealId getId() {
            return ItemMessage.this.Id;
        }

        @Override
        public UnrealId getNavPointId() {
            return ItemMessage.this.NavPointId;
        }

        @Override
        public NavPoint getNavPoint() {
            return ItemMessage.this.NavPoint;
        }

        @Override
        public int getAmount() {
            return ItemMessage.this.Amount;
        }

        @Override
        public ItemType getType() {
            return ItemMessage.this.Type;
        }

        @Override
        public ItemDescriptor getDescriptor() {
            return ItemMessage.this.Descriptor;
        }

        @Override
        public boolean isDifferentFrom(IStaticWorldObject other) {
            if (other == null) {
                return true;
            }
            if (other == this) {
                return false;
            }
            ItemStatic obj = (ItemStatic)other;
            if (!AdvancedEquals.equalsOrNull((Object)this.getId(), (Object)obj.getId())) {
                System.out.println("!!!!!PROPERTY UPDATE ERROR!!!! on property Id on object class ItemStatic");
                return true;
            }
            if (!AdvancedEquals.equalsOrNull((Object)this.getNavPointId(), (Object)obj.getNavPointId())) {
                System.out.println("!!!!!PROPERTY UPDATE ERROR!!!! on property NavPointId on object class ItemStatic");
                return true;
            }
            if (!AdvancedEquals.equalsOrNull((Object)this.getNavPoint(), (Object)obj.getNavPoint())) {
                System.out.println("!!!!!PROPERTY UPDATE ERROR!!!! on property NavPoint on object class ItemStatic");
                return true;
            }
            if (this.getAmount() != obj.getAmount()) {
                System.out.println("!!!!!PROPERTY UPDATE ERROR!!!! on property Amount on object class ItemStatic");
                return true;
            }
            if (!AdvancedEquals.equalsOrNull((Object)this.getType(), (Object)obj.getType())) {
                System.out.println("!!!!!PROPERTY UPDATE ERROR!!!! on property Type on object class ItemStatic");
                return true;
            }
            if (!AdvancedEquals.equalsOrNull((Object)this.getDescriptor(), (Object)obj.getDescriptor())) {
                System.out.println("!!!!!PROPERTY UPDATE ERROR!!!! on property Descriptor on object class ItemStatic");
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return super.toString() + "[" + "Id = " + String.valueOf(this.getId()) + " | " + "NavPointId = " + String.valueOf(this.getNavPointId()) + " | " + "Amount = " + String.valueOf(this.getAmount()) + " | " + "Type = " + String.valueOf(this.getType()) + " | " + "]";
        }

        @Override
        public String toHtmlString() {
            return super.toString() + "[<br/>" + "<b>Id</b> = " + String.valueOf(this.getId()) + " <br/> " + "<b>NavPointId</b> = " + String.valueOf(this.getNavPointId()) + " <br/> " + "<b>Amount</b> = " + String.valueOf(this.getAmount()) + " <br/> " + "<b>Type</b> = " + String.valueOf(this.getType()) + " <br/> " + "<br/>]";
        }
    }

    public class ItemLocalMessage
    extends ItemLocal {
        @Override
        public ItemLocalMessage clone() {
            return this;
        }

        @Override
        public ItemLocalMessage getLocal() {
            return this;
        }

        @Override
        public ISharedWorldObject getShared() {
            throw new UnsupportedOperationException("Could not return LOCAL as SHARED");
        }

        @Override
        public IStaticWorldObject getStatic() {
            throw new UnsupportedOperationException("Could not return LOCAL as STATIC");
        }

        @Override
        public UnrealId getId() {
            return ItemMessage.this.Id;
        }

        @Override
        public boolean isVisible() {
            return ItemMessage.this.Visible;
        }

        @Override
        public boolean isReachable() {
            return ItemMessage.this.Reachable;
        }

        @Override
        public String toString() {
            return super.toString() + "[" + "Id = " + String.valueOf(this.getId()) + " | " + "Visible = " + String.valueOf(this.isVisible()) + " | " + "Reachable = " + String.valueOf(this.isReachable()) + " | " + "]";
        }

        @Override
        public String toHtmlString() {
            return super.toString() + "[<br/>" + "<b>Id</b> = " + String.valueOf(this.getId()) + " <br/> " + "<b>Visible</b> = " + String.valueOf(this.isVisible()) + " <br/> " + "<b>Reachable</b> = " + String.valueOf(this.isReachable()) + " <br/> " + "<br/>]";
        }
    }
}

