/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.worldview;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.MockMediator;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.WorldViewTestContext;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapper;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapperWithCallCount;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.InputEventWrapper;
import cz.cuni.amis.pogamut.ut2004.component.ComponentStub;
import cz.cuni.amis.utils.Const;
import cz.cuni.amis.utils.NullCheck;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractWorldViewTest {
    private WorldViewTestContext ctx;
    private AgentId agentId;
    private IAgentLogger logger;
    private ComponentBus bus;
    private ComponentStub worldViewController;
    private LogCategory log;

    public AgentId getAgentId() {
        return this.agentId;
    }

    public IAgentLogger getLogger() {
        return this.logger;
    }

    public Logger getLog() {
        return this.log;
    }

    public ComponentBus getBus() {
        return this.bus;
    }

    public ComponentStub getWorldViewController() {
        return this.worldViewController;
    }

    public WorldViewTestContext getContext() {
        return this.ctx;
    }

    @Test
    public void testWorldView() {
        this.doTest();
    }

    protected abstract IWorldView createWorldView(IAgentLogger var1, ComponentBus var2, ComponentStub var3, MockMediator var4);

    protected AbstractWorldViewTest(File planFile) {
        Assert.assertTrue((String)"planFile is null.", (planFile != null ? 1 : 0) != 0);
        this.agentId = new AgentId("WorldViewTest");
        this.logger = new AgentLogger((IAgentId)this.agentId);
        this.log = this.logger.getCategory("Test");
        this.logger.addDefaultConsoleHandler();
        this.logger.setLevel(Level.ALL);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Inicializing: " + this.getClass().getSimpleName());
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Plan: " + planFile.getAbsolutePath());
        }
        this.bus = new ComponentBus(this.logger);
        this.worldViewController = new ComponentStub(this.logger, (IComponentBus)this.bus);
        this.ctx = new WorldViewTestContext(planFile, (Logger)this.log, this.createWorldView(this.getLogger(), this.getBus(), this.getWorldViewController(), new MockMediator()));
    }

    protected IWorldChangeEvent clone(IWorldChangeEvent msg) {
        NullCheck.check((Object)msg, (String)"msg");
        try {
            return (IWorldChangeEvent)msg.getClass().getConstructor(msg.getClass()).newInstance(msg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void doTest() {
        this.getWorldViewController().getController().manualStart("Starting the worldview.");
        this.ctx.getRunningFlag().setFlag((Object)true);
        this.preTest();
        for (EventWrapper eventWrapper : this.ctx.getContainer().getEventWrappers()) {
            eventWrapper.registerToWorldView(this.ctx.getWorldView());
        }
        this.preNotifications();
        for (InputEventWrapper inputEventWrapper : this.ctx.getContainer().getInputEventsPlan()) {
            for (int i = 0; i < inputEventWrapper.getRaiseTimes(); ++i) {
                if (this.ctx.getLog().isLoggable(Level.INFO)) {
                    this.ctx.getLog().info("Notifying wrapper: " + inputEventWrapper.getEvent().toString());
                }
                this.ctx.getWorldView().notify(this.clone(inputEventWrapper.getEvent()));
            }
        }
        if (this.ctx.getLog().isLoggable(Level.INFO)) {
            this.ctx.getLog().info("postNotifications");
        }
        this.postNotifications();
        this.ctx.getRunningFlag().setFlag((Object)false);
        if (this.ctx.getLog().isLoggable(Level.INFO)) {
            this.ctx.getLog().info("postTest");
        }
        this.postTest();
        this.getWorldViewController().getController().manualStop("Stopping the worldview.");
        for (EventWrapperWithCallCount eventWrapperWithCallCount : this.ctx.getContainer().getExpectedEventsPlan()) {
            if (eventWrapperWithCallCount.hasBeenCalledExpectedNumberOfTimes()) continue;
            String str = "Event has not been called enough times." + Const.NEW_LINE + "Expected event:" + eventWrapperWithCallCount.getEventWrapper().getExpectedEventString() + Const.NEW_LINE + "Called: " + eventWrapperWithCallCount.getCalled() + " expected calls: " + eventWrapperWithCallCount.getExpectedNumberOfCalls();
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(str);
            }
            Assert.fail((String)str);
        }
        System.out.println("---/// TEST OK ///---");
    }

    protected final synchronized void fail(String message) {
        if (message != null) {
            Assert.fail((String)message);
        } else {
            Assert.fail();
        }
    }

    protected abstract void preNotifications();

    protected abstract void postNotifications();

    protected abstract void preTest();

    protected abstract void postTest();
}

