package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan;

import java.util.LinkedList;

import com.thoughtworks.xstream.annotations.XStreamAlias;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapper;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapperWithCallCount;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.InputEventWrapper;

/**
 * Unmarshalled data from a test plan is returning using this class.
 * @author Radek 'Black_Hand' Pibil
 *
 */
@XStreamAlias("TestPlan")
public class WorldViewTestPlanContainer {
	
	@XStreamAlias("InputEvents")
	protected LinkedList<? extends IWorldChangeEvent> inputEvents;
	
	@XStreamAlias("ExpectedEvents")
	protected LinkedList<? extends IWorldEvent> expectedEvents;
	
	@XStreamAlias("EventWrappers")
	protected LinkedList<EventWrapper> eventWrappers;
	
	@XStreamAlias("InputEventsPlan")
	protected LinkedList<InputEventWrapper> inputEventsPlan;	
	
	@XStreamAlias("ExpectedEventsPlan")
	protected LinkedList<EventWrapperWithCallCount> expectedEventsPlan;

	public void assignInputEvents(LinkedList<? extends IWorldChangeEvent> inputEvents) {
		if (inputEvents == null)
			throw new IllegalArgumentException(
					"inputEvents for WorldViewTestPlanController has to be != null.");		
		this.inputEvents = inputEvents;
	}
	
	public void assignExpectedEvents(LinkedList<? extends IWorldEvent> expectedEvents) {
		if (expectedEvents == null)
			throw new IllegalArgumentException(
					"expectedEvents for WorldViewTestPlanController has to be != null.");		
		this.expectedEvents = expectedEvents;
	}
	
	public void assignEventWrappers(LinkedList<EventWrapper> eventWrappers) {
		this.eventWrappers = eventWrappers;
	}
	
	public void assignInputEventsPlan(LinkedList<InputEventWrapper> inputEventsPlan) {
		this.inputEventsPlan = inputEventsPlan;
	}	
	
	public void assignExpectedEventsPlan(LinkedList<EventWrapperWithCallCount> plan) {
		if (plan == null)
			throw new IllegalArgumentException(
					"plan for WorldViewTestPlanController has to be != null.");			
		this.expectedEventsPlan = plan;
	}

	public void addEventWrapper(EventWrapper eventWrapper) {
		eventWrappers.add(eventWrapper);
	}
	
	
	public LinkedList<? extends IWorldChangeEvent> getInputEvents() {
		return inputEvents;
	}

	public LinkedList<? extends IWorldEvent> getExpectedEvents() {
		return expectedEvents;
	}

	public LinkedList<? extends EventWrapper> getEventWrappers() {
		return eventWrappers;
	}

	public LinkedList<? extends EventWrapperWithCallCount> getExpectedEventsPlan() {
		return expectedEventsPlan;
	}
	
	public LinkedList<InputEventWrapper> getInputEventsPlan() {
		return inputEventsPlan;
	}
}
