/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.IItemUsefulness;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.utils.NullCheck;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AdvancedItems {
    private IItemUsefulness filter;
    private Items items;

    public Map<UnrealId, Item> getSpawnedItems(double usefulness) {
        return this.filterUsefulItems(this.items.getSpawnedItems().values(), usefulness);
    }

    public Map<UnrealId, Item> getSpawnedItems(ItemType type, double usefulness) {
        return this.filterUsefulItems(this.items.getSpawnedItems(type).values(), usefulness);
    }

    public Map<UnrealId, Item> getSpawnedItems(ItemType.Category category, double usefulness) {
        return this.filterUsefulItems(this.items.getSpawnedItems(category).values(), usefulness);
    }

    public Map<UnrealId, Item> getSpawnedItems(ItemType.Group group, double usefulness) {
        return this.filterUsefulItems(this.items.getSpawnedItems(group).values(), usefulness);
    }

    public Map<UnrealId, Item> getAllItems(double usefulness) {
        return this.filterUsefulItems(this.items.getAllItems().values(), usefulness);
    }

    public Map<UnrealId, Item> getAllItems(ItemType type, double usefulness) {
        return this.filterUsefulItems(this.items.getAllItems(type).values(), usefulness);
    }

    public Map<UnrealId, Item> getAllItems(ItemType.Category category, double usefulness) {
        return this.filterUsefulItems(this.items.getAllItems(category).values(), usefulness);
    }

    public Map<UnrealId, Item> getAllItems(ItemType.Group group, double usefulness) {
        return this.filterUsefulItems(this.items.getAllItems(group).values(), usefulness);
    }

    public Map<UnrealId, Item> getVisibleItems(double usefulness) {
        return this.filterUsefulItems(this.items.getVisibleItems().values(), usefulness);
    }

    public Map<UnrealId, Item> getVisibleItems(ItemType type, double usefulness) {
        return this.filterUsefulItems(this.items.getVisibleItems(type).values(), usefulness);
    }

    public Map<UnrealId, Item> getVisibleItems(ItemType.Category category, double usefulness) {
        return this.filterUsefulItems(this.items.getVisibleItems(category).values(), usefulness);
    }

    public Map<UnrealId, Item> getVisibleItems(ItemType.Group group, double usefulness) {
        return this.filterUsefulItems(this.items.getVisibleItems(group).values(), usefulness);
    }

    public Map<UnrealId, Item> getReachableItems(double usefulness) {
        return this.filterUsefulItems(this.items.getReachableItems().values(), usefulness);
    }

    public Map<UnrealId, Item> getReachableItems(ItemType type, double usefulness) {
        return this.filterUsefulItems(this.items.getReachableItems(type).values(), usefulness);
    }

    public Map<UnrealId, Item> getReachableItems(ItemType.Category category, double usefulness) {
        return this.filterUsefulItems(this.items.getReachableItems(category).values(), usefulness);
    }

    public Map<UnrealId, Item> getReachableItems(ItemType.Group group, double usefulness) {
        return this.filterUsefulItems(this.items.getReachableItems(group).values(), usefulness);
    }

    public Map<UnrealId, Item> getKnownPickups(double usefulness) {
        return this.filterUsefulItems(this.items.getKnownPickups().values(), usefulness);
    }

    public Map<UnrealId, Item> getKnownPickups(ItemType type, double usefulness) {
        return this.filterUsefulItems(this.items.getKnownPickups(type).values(), usefulness);
    }

    public Map<UnrealId, Item> getKnownPickups(ItemType.Category category, double usefulness) {
        return this.filterUsefulItems(this.items.getKnownPickups(category).values(), usefulness);
    }

    public Map<UnrealId, Item> getKnownPickups(ItemType.Group group, double usefulness) {
        return this.filterUsefulItems(this.items.getKnownPickups(group).values(), usefulness);
    }

    public boolean isItemUseful(Item item, double usefulness) {
        if (usefulness < 0.0) {
            usefulness = 0.0;
        } else if (usefulness > 1.0) {
            usefulness = 1.0;
        }
        return this.filter.getItemUsefulness(this, this.items, item, usefulness) >= usefulness;
    }

    public Map<UnrealId, Item> filterUsefulItems(Collection<Item> items, double usefulness) {
        HashMap<UnrealId, Item> map = new HashMap<UnrealId, Item>();
        for (Item i : items) {
            if (!this.isItemUseful(i, usefulness)) continue;
            map.put(i.getId(), i);
        }
        return map;
    }

    public Items getItems() {
        return this.items;
    }

    public AdvancedItems(UT2004Bot bot, IItemUsefulness filter) {
        this(new Items(bot), filter);
    }

    public AdvancedItems(Items items, IItemUsefulness filter) {
        this.items = items;
        NullCheck.check((Object)((Object)this.items), (String)"items");
        this.filter = filter;
    }
}

