/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot.command;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.command.SimpleShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Shoot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StopShooting;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import java.util.logging.Logger;

public class AdvancedShooting
extends SimpleShooting {
    private double currentTime = 0.0;
    private double lastChargeShootCommandTime = -1.0;
    private double lastChargeShootCommandDelay = 0.0;
    private IWorldEventListener<BeginMessage> myBegListener = new IWorldEventListener<BeginMessage>(){

        public void notify(BeginMessage bm) {
            AdvancedShooting.this.currentTime = bm.getTime();
            if (AdvancedShooting.this.lastChargeShootCommandTime >= 0.0 && AdvancedShooting.this.currentTime - AdvancedShooting.this.lastChargeShootCommandTime > AdvancedShooting.this.lastChargeShootCommandDelay) {
                ((UT2004Bot)AdvancedShooting.this.agent).getAct().act((CommandMessage)new StopShooting());
                AdvancedShooting.this.lastChargeShootCommandTime = -1.0;
                AdvancedShooting.this.lastChargeShootCommandDelay = 0.0;
            }
        }
    };

    public void stopShooting() {
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)new StopShooting());
    }

    public void shootWithMode(boolean secondaryMode) {
        Shoot shoot = new Shoot();
        shoot.setAlt(secondaryMode);
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)shoot);
    }

    public void shootSecondary() {
        Shoot shoot = new Shoot();
        shoot.setAlt(true);
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)shoot);
    }

    public void shootPrimary(ILocated location) {
        if (location instanceof Player) {
            this.shootPrimary((Player)location);
            return;
        }
        Shoot shoot = new Shoot();
        shoot.setLocation(location.getLocation());
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)shoot);
    }

    public void shootPrimary(UnrealId target) {
        Shoot shoot = new Shoot();
        shoot.setTarget(target);
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)shoot);
    }

    public void shootPrimary(Player target) {
        this.shootPrimary(target.getId());
    }

    public void shootSecondary(ILocated location) {
        if (location instanceof Player) {
            this.shootSecondary((Player)location);
            return;
        }
        Shoot shoot = new Shoot();
        shoot.setLocation(location.getLocation());
        shoot.setAlt(true);
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)shoot);
    }

    public void shootSecondary(UnrealId target) {
        Shoot shoot = new Shoot();
        shoot.setTarget(target);
        shoot.setAlt(true);
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)shoot);
    }

    public void shootSecondary(Player target) {
        this.shootSecondary(target.getId());
    }

    public void shootPrimaryCharged(ILocated location, double chargeTime) {
        if (location instanceof Player) {
            this.shootPrimaryCharged((Player)location, chargeTime);
            return;
        }
        Shoot shoot = new Shoot();
        shoot.setLocation(location.getLocation());
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)shoot);
        this.lastChargeShootCommandTime = this.currentTime;
        this.lastChargeShootCommandDelay = chargeTime;
    }

    public void shootPrimaryCharged(UnrealId target, double chargeTime) {
        Shoot shoot = new Shoot();
        shoot.setTarget(target);
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)shoot);
        this.lastChargeShootCommandTime = this.currentTime;
        this.lastChargeShootCommandDelay = chargeTime;
    }

    public void shootPrimaryCharged(Player target, double chargeTime) {
        this.shootPrimaryCharged(target.getId(), chargeTime);
    }

    public void shootSecondaryCharged(ILocated location, double chargeTime) {
        if (location instanceof Player) {
            this.shootSecondaryCharged((Player)location, chargeTime);
            return;
        }
        Shoot shoot = new Shoot();
        shoot.setLocation(location.getLocation());
        shoot.setAlt(true);
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)shoot);
        this.lastChargeShootCommandTime = this.currentTime;
        this.lastChargeShootCommandDelay = chargeTime;
    }

    public void shootSecondaryCharged(UnrealId target, double chargeTime) {
        Shoot shoot = new Shoot();
        shoot.setTarget(target);
        shoot.setAlt(true);
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)shoot);
        this.lastChargeShootCommandTime = this.currentTime;
        this.lastChargeShootCommandDelay = chargeTime;
    }

    public void shootSecondaryCharged(Player target, double chargeTime) {
        this.shootSecondaryCharged(target.getId(), chargeTime);
    }

    protected void reset() {
        this.lastChargeShootCommandTime = -1.0;
        this.lastChargeShootCommandDelay = 0.0;
    }

    public AdvancedShooting(UT2004Bot agent, Logger log) {
        super(agent, log);
        agent.getWorldView().addEventListener(BeginMessage.class, this.myBegListener);
    }

    @Override
    public void shoot() {
        super.shoot();
    }

    @Override
    public void shoot(UnrealId target) {
        super.shoot(target);
    }

    @Override
    public void shoot(Player target) {
        super.shoot(target);
    }

    @Override
    public void stopShoot() {
        super.stopShoot();
    }
}

