package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper;

import org.junit.Assert;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.ListenerLevel;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.WorldViewTestContext;
import java.util.logging.Level;

/**
 * Wraps a single event from a sequence of a same event, repeated
 * a set number of times (listener for A level events).
 * @author Radek 'Black_Hand' Pibil
 */
@XStreamAlias("EventWrapper")
public class EventWrapper implements IWorldEventListener<IWorldEvent> {
	
	@XStreamAlias("ExpectedEvent")
	private final IWorldEvent expectedEvent;
	@XStreamOmitField
	private final String expectedEventString;
	@XStreamAlias("level")
	@XStreamAsAttribute
	private final ListenerLevel level;
	protected WorldViewTestContext ctx;		
	
	public EventWrapper(WorldViewTestContext ctx, IWorldEvent expectedEvent) {
		this(ctx, expectedEvent, ListenerLevel.A);		
	}
	
	protected EventWrapper(
			WorldViewTestContext ctx,
			IWorldEvent expectedEvent,
			ListenerLevel level) {
		
		this.expectedEvent = expectedEvent;		
		expectedEventString = expectedEvent.toString();
		this.level = level;
		this.ctx = ctx;
	}
	
	public IWorldEvent getExpectedEvent() {
		return expectedEvent;
	}		
			
	public String getExpectedEventString() {
		return expectedEventString;
	}		
	
	/**
	 * This method compares an event currently raised by tested world view,
	 * to the expected event. World view calls it by itself.
	 * @param event currently raised event
	 */
	@Override
	public void notify(IWorldEvent event) {
		EventWrapperWithCallCount mock_wrapper_with_counts = ctx.getCurrentMockWrapper();
		
		if (ctx.getLog().isLoggable(Level.INFO)) ctx.getLog().info("Expected event: " +
				mock_wrapper_with_counts.getEventWrapper().getExpectedEventString());
		
		if (getClass() == EventWrapper.class) {
			if (ctx.getLog().isLoggable(Level.INFO)) ctx.getLog().info("Received event: " + event.toString());
			Assert.assertTrue("Event types do not match.\nNotified with: " + event.toString() +
					"\nExpected: " +
					mock_wrapper_with_counts.getEventWrapper().getExpectedEventString() +
					"\nThis wrapper: " + getExpectedEventString(),
					event.getClass().equals(getExpectedEvent().getClass()) &&
					event.getClass().equals(
							mock_wrapper_with_counts.getEventWrapper().
								getExpectedEvent().getClass()));
					
			Assert.assertTrue("Event types do match, but not the events themselves.\n" + 
				"Notified with: " + event.toString() + " expected: " + getExpectedEventString(),
				getClass() != EventWrapper.class ||
					event.toString().equals(getExpectedEventString()));
			
			if (ctx.getLog().isLoggable(Level.INFO)) ctx.getLog().info("EventWrapper notify: " + getExpectedEventString() + " call#: " +
					(mock_wrapper_with_counts.getCalled() + 1));						
		}
		mock_wrapper_with_counts.incCalled();
	}

	/**
	 * Tests whether this wrapped event is already listened to by worldview 
	 */
	public void registerToWorldView(IWorldView worldView) {
		if (!ctx.getWorldView().isListening(expectedEvent.getClass(), this)) {
			if (ctx.getLog().isLoggable(Level.INFO)) ctx.getLog().info("Registering listener of: " + getExpectedEventString());
			ctx.getWorldView().addEventListener(expectedEvent.getClass(), this);
		}
	}
	
	public ListenerLevel getListenerLevel() {
		return level;
	}
}
