package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper;

import org.junit.Assert;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.ListenerLevel;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.WorldViewTestContext;
import java.util.logging.Level;

/**
 * Wrapper class for B or C level event listener. Binds itself to a given objectClass.
 * @author Radek 'Black_Hand' Pibil
 *
 * @param <OBJECT> object class to bind to
 */
@XStreamAlias("ObjectClassEventWrapper")
public class ObjectClassEventWrapper<OBJECT extends IWorldObject>
		extends AbstractObjectEventWrapper<OBJECT> {

	@XStreamAlias("Class")
	private final Class<OBJECT> objectClass;
	@XStreamOmitField
	private ObjectClassListenerWrapper<?> listenerWrapper;
	
	public ObjectClassEventWrapper(
			WorldViewTestContext ctx,
			IWorldObjectEvent<OBJECT> expectedEvent,
			Class<OBJECT> objectClass, ListenerLevel level
	) {
		super(ctx, expectedEvent, level);
			
		Assert.assertTrue("Use ObjectEventWrapper, if you wish to register a class D or E listener.",
				level == ListenerLevel.B || level == ListenerLevel.C);				
		
		this.objectClass = objectClass;
	}	
	
	@Override
	protected void setListenerWrapper() {
		this.listenerWrapper = new ObjectClassListenerWrapper<IWorldObjectEvent<OBJECT>>();
	}		
	
	/**
	 * Helper class that actually listens for the expected event on given class
	 * @author Radek 'Black_Hand' Pibil
	 *
	 * @param <EVENT> event class to listen to
	 */
	protected class ObjectClassListenerWrapper<EVENT extends IWorldObjectEvent<OBJECT>>
		implements IWorldObjectEventListener<OBJECT, EVENT> {

		@Override
		public void notify(EVENT event) {
			EventWrapperWithCallCount mock_wrapper_with_counts = ctx.getCurrentMockWrapper();
			if (ctx.getLog().isLoggable(Level.INFO)) ctx.getLog().info("ObjectClassListenerNotify: " + event.toString() +
					" call#: " + 
					(mock_wrapper_with_counts.getCalled() + 1));
			
			Assert.assertTrue("Unexpected event has been raised (possibly out of order).\n" +
					event.toString() + "\nExpected for this listener: " + getExpectedEventString() +
					"\nExpected for strict execution: " +
					mock_wrapper_with_counts.getEventWrapper().getExpectedEventString(),
					!ctx.isStrictExecution() ||
					(
						event.getClass() ==
							mock_wrapper_with_counts.getEventWrapper().
							getExpectedEvent().getClass() &&							
						getObjectClass() == event.getObject().getClass()
					)
			);				
			
			ObjectClassEventWrapper.this.notify(event);
		}			
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void registerToWorldView(IWorldView worldView) {
		if (!ctx.getWorldView().isListening(objectClass, listenerWrapper) &&
			!ctx.getWorldView().isListening(objectClass, getExpectedEvent().getClass(),
				listenerWrapper))
		{				
			if (ctx.getLog().isLoggable(Level.INFO)) ctx.getLog().info("Registering listener of: " + getExpectedEventString());
			switch (getListenerLevel()) {
			case B:
				worldView.addObjectListener(objectClass,
						(IWorldObjectEventListener) listenerWrapper);
				break;
			case C:
				worldView.addObjectListener(objectClass, getExpectedEvent().getClass(),
						listenerWrapper);
				break;
			}			
		}
	}		
		
	public Class<OBJECT> getObjectClass() {
		return objectClass;
	}		
}	
