package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.LinkedList;

import org.junit.Assert;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;

public class PlanFileNameLoader {

	public static Collection<File[]> loadPlanFileNames(Class<? extends IWorldView> worldViewClass) {
	    
	    Assert.assertTrue("No default test class exists for WorldViewTestCase to test. " +
	    		"You have to specify one, in the WorldViewTestClass parameter of JavaVM.",
	    		worldViewClass != null);
			    
	    File dir = new File("target/test-classes/testplans/WorldView/" + worldViewClass.getName() + "/");	    
	    
	    LinkedList<File[]> output = new LinkedList<File[]>();
	    FilenameFilter filter = new FilenameFilter() {
			@Override
			public boolean accept(File dir, String name) {
				return name.endsWith(".xml");
			}
		};
	    for (String file : dir.list(filter)) {
	    	output.add(new File[]{ new File(dir.getAbsolutePath() + "/" + file)});
	    }
		
		return output;
	}	
	
}
