/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot.killbot;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.bot.killbot.KillBotParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.utils.flag.FlagInteger;

public class KillBotController
extends UT2004BotModuleController<UT2004Bot> {
    KillBotParameters params;
    boolean turned = false;
    boolean utilRespawn = false;
    FlagInteger killed = new FlagInteger(Integer.valueOf(0));

    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        super.botInitialized(gameInfo, currentConfig, init);
        this.params = (KillBotParameters)this.bot.getParams();
        this.config.setManualSpawn(true);
    }

    public void logic() {
        if (this.info.getLocation().getDistance(this.params.getSpawningLocation()) > 100.0) {
            this.respawn();
            this.utilRespawn = true;
            return;
        }
        if (!this.turned) {
            this.body.getLocomotion().turnTo((ILocated)this.params.getTurnToLocation());
        }
        if (this.players.canSeeEnemies()) {
            this.body.getShooting().shoot(this.players.getNearestVisibleEnemy());
        } else {
            this.body.getShooting().stopShoot();
        }
    }

    private void respawn() {
        this.getAct().act((CommandMessage)new Respawn().setStartLocation(this.params.getSpawningLocation()));
    }

    public void botKilled(BotKilled event) {
        this.turned = false;
        if (this.utilRespawn) {
            this.utilRespawn = false;
            return;
        }
        this.killed.increment(1);
        this.getLog().warning("Bot KILLED (" + this.killed.getFlag() + "x)");
        this.respawn();
    }

    public FlagInteger getKilled() {
        return this.killed;
    }
}

