package cz.cuni.amis.pogamut.ut2004multi.communication.worldview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ICompositeWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ILocalWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.BatchAwareLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ICompositeWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.UT2004CompositeObjectCreator;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects.ILocalGBViewable;

public abstract class UT2004VisionLocalWorldView extends BatchAwareLocalWorldView{

	public UT2004VisionLocalWorldView(ComponentDependencies dependencies,
			ILifecycleBus bus, IAgentLogger logger,
			ISharedWorldView parentWorldView, ITeamedAgentId agentId) {
		super(dependencies, bus, logger, parentWorldView, agentId);
		// TODO Auto-generated constructor stub
	}
	
	@Override
	protected ICompositeWorldObject createCompositeObject(ILocalWorldObject localObject, ISharedWorldObject sharedObject, IStaticWorldObject staticObject)
	{
		return UT2004CompositeObjectCreator.createObject(localObject, sharedObject, staticObject);
	}
	
	protected Collection<ILocalGBViewable> lastBatch = new ArrayList<ILocalGBViewable>();
	protected Collection<ILocalGBViewable> currentBatch = new ArrayList<ILocalGBViewable>();
	
	@Override
	public synchronized void notify(IWorldChangeEvent event)
	{
		if ( event instanceof ILocalWorldObjectUpdatedEvent )
		{
			localEventNotify((ILocalWorldObjectUpdatedEvent)event);
		}
		else if ( event instanceof ICompositeWorldObjectUpdatedEvent )
		{
			ILocalWorldObjectUpdatedEvent locEvent = ((ICompositeWorldObjectUpdatedEvent)event).getLocalEvent();
			if ( locEvent != null)
			{
				localEventNotify(locEvent);
			}
		}
		else if ( isBatchEndEvent(event))
		{
			processBatches();
		}
		super.notify(event);
	}
	
	/**
	 * Disappears objects that should not be visible (update was not recieved in this batch);
	 */
	private void processBatches()
	{
		this.lastBatch.removeAll(currentBatch);
		for( ILocalGBViewable obj : lastBatch)
		{
			ILocalWorldObjectUpdatedEvent disEvent = obj.createDisappearEvent();
			super.objectUpdatedEvent(disEvent);
		}
		this.lastBatch = this.currentBatch;
		currentBatch = new ArrayList<ILocalGBViewable>(this.lastBatch.size() + 10);
	}
	
	/**
	 * If the event updates a Viewable object, this method manages making it disappear when no update is recieved for it
	 * - this means the object is not in FoW of our agent.
	 * @param event
	 */
	protected void localEventNotify(ILocalWorldObjectUpdatedEvent event)
	{
		ILocalWorldObject obj = getMostRecentLocalWorldObject(event.getId());
		if ( obj != null)
		{
			if ( obj instanceof ILocalGBViewable )
			{
				currentBatch.add((ILocalGBViewable)obj);
			}
		}
	}

}
