package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper;

import org.junit.Assert;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.ListenerLevel;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.WorldViewTestContext;
import java.util.logging.Level;

/**
 * Wrapper class for D or E level event listener. Binds itself to a given objectClass.
 * @author Radek 'Black_Hand' Pibil
 *
 * @param <OBJECT> object class to bind to
 */
@XStreamAlias("ObjectInstanceEventWrapper")
public class ObjectInstanceEventWrapper<OBJECT extends IWorldObject>
		extends AbstractObjectEventWrapper<OBJECT> {
	
	@XStreamAlias("Id")
	private final UnrealId id;
	@XStreamOmitField
	private ObjectInstanceListenerWrapper<IWorldObjectEvent<OBJECT>> listenerWrapper;
	
	public ObjectInstanceEventWrapper(
			WorldViewTestContext ctx,
			IWorldObjectEvent<OBJECT> expectedEvent,
			UnrealId id,
			ListenerLevel level
	) {
		super(ctx, expectedEvent, level);
		
		Assert.assertTrue("Use ObjectClassEventWrapper, if you wish to register a class B or C listener.",
				level == ListenerLevel.D || level == ListenerLevel.E);		
		
		this.id = id;
	}
	
	/**
	 * Helper class that actually listens for the expected event on given instance of class.
	 * @author Radek 'Black_Hand' Pibil
	 *
	 * @param <EVENT> event class to listen to
	 */
	protected class ObjectInstanceListenerWrapper<EVENT extends IWorldObjectEvent<OBJECT>>
		implements IWorldObjectEventListener<OBJECT, EVENT> {

		@SuppressWarnings("unchecked")
		@Override
		public void notify(EVENT event) {
			EventWrapperWithCallCount mock_wrapper_with_counts = ctx.getCurrentMockWrapper();
			if (ctx.getLog().isLoggable(Level.INFO)) ctx.getLog().info("ObjectInstanceListenerNotify: " + event.toString() +
					" call#: " + 
					(mock_wrapper_with_counts.getCalled() + 1));
			
			Assert.assertTrue("Invalid UnrealId reported with event: " + event.toString() +
						"\n" + id.getStringId() + " was expected.",
						event.getId().getStringId().equals(id.getStringId()));				
							
			EventWrapper test = mock_wrapper_with_counts.getEventWrapper();
			
			Assert.assertTrue("Unexpected event has been raised (possibly out of order).\n" +
					event.toString() + "\nExpected for this listener: " + getExpectedEventString() +
					"\nExpected for strict execution: " +
					mock_wrapper_with_counts.getEventWrapper().getExpectedEventString(),
					!ctx.isStrictExecution() ||
					(
						test.getExpectedEvent().equals(getExpectedEvent()) &&
						event.getClass() ==	test.getExpectedEvent().getClass() &&
						mock_wrapper_with_counts.getEventWrapper()
							instanceof ObjectInstanceEventWrapper<?> &&							
						event.getId().equals(
								((ObjectInstanceEventWrapper<OBJECT>)
										mock_wrapper_with_counts.getEventWrapper()).getId()) &&							
						id.equals(
								((ObjectInstanceEventWrapper<OBJECT>)
										mock_wrapper_with_counts.getEventWrapper()).getId())
					)
			);				
			
			ObjectInstanceEventWrapper.this.notify(event);
		}			
	}
	
	@Override
	protected void setListenerWrapper() {
		this.listenerWrapper = new ObjectInstanceListenerWrapper<IWorldObjectEvent<OBJECT>>(); 
	}

	@Override
	public void registerToWorldView(IWorldView worldView) {
		if (!worldView.isListening(id, listenerWrapper) &&
				!worldView.isListening(id, getExpectedEvent().getClass(),
						listenerWrapper)) {
			if (ctx.getLog().isLoggable(Level.INFO)) ctx.getLog().info("Registering listener of: " + getExpectedEventString());
			switch (getListenerLevel()) {
			case D:
				worldView.addObjectListener(id, listenerWrapper);
				break;
			case E:
				worldView.addObjectListener(id, getExpectedEvent().getClass(), listenerWrapper);
				break;
			}			
		}
	}		
	
	public UnrealId getId() {
		return id;
	}
}	
