/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.logic;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReact;
import cz.cuni.amis.pogamut.base.communication.worldview.react.ObjectEventReact;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base3d.ILockableVisionWorldView;
import cz.cuni.amis.pogamut.ut2004.agent.module.logic.UT2004BotLogic;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SyncUT2004BotLogic<BOT extends UT2004Bot<? extends ILockableVisionWorldView, ?, ?>>
extends UT2004BotLogic<BOT> {
    private ObjectEventReact<ConfigChange, ?> configChangeReaction;
    private EventReact<EndMessage> endReactionAfterRespawn;
    private int shouldExecuteLogicLatch = 0;
    private ICommandListener<Respawn> respawnListener = new ICommandListener<Respawn>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(Respawn event) {
            ICommandListener iCommandListener = SyncUT2004BotLogic.this.respawnListener;
            synchronized (iCommandListener) {
                SyncUT2004BotLogic.this.endReactionAfterRespawn.enable();
                SyncUT2004BotLogic.this.shouldExecuteLogicLatch = 2;
            }
        }
    };

    @Inject
    public SyncUT2004BotLogic(BOT agent, IAgentLogic logic) {
        this(agent, logic, null, new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add(((UT2004Bot)agent).getWorldView()));
    }

    public SyncUT2004BotLogic(BOT agent, IAgentLogic logic, Logger log) {
        this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add(((UT2004Bot)agent).getWorldView()));
    }

    public SyncUT2004BotLogic(BOT agent, IAgentLogic logic, Logger log, ComponentDependencies dependencies) {
        super(agent, logic, log, dependencies);
        this.endReactionAfterRespawn = new EventReact<EndMessage>(EndMessage.class, ((UT2004Bot)agent).getWorldView()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void react(EndMessage event) {
                ICommandListener iCommandListener = SyncUT2004BotLogic.this.respawnListener;
                synchronized (iCommandListener) {
                    if (SyncUT2004BotLogic.this.shouldExecuteLogicLatch > 0) {
                        SyncUT2004BotLogic syncUT2004BotLogic = SyncUT2004BotLogic.this;
                        syncUT2004BotLogic.shouldExecuteLogicLatch = syncUT2004BotLogic.shouldExecuteLogicLatch - 1;
                    }
                }
            }
        };
        agent.getAct().addCommandListener(Respawn.class, this.respawnListener);
        this.configChangeReaction = new ObjectEventReact<ConfigChange, IWorldObjectEvent<ConfigChange>>(ConfigChange.class, ((UT2004Bot)agent).getWorldView()){

            protected void react(IWorldObjectEvent<ConfigChange> event) {
                SyncUT2004BotLogic.this.setLogicFrequency(1.0 / Math.max(0.1, ((ConfigChange)event.getObject()).getVisionTime() - 0.02));
            }
        };
    }

    protected void beforeLogic(String threadName) {
        super.beforeLogic(threadName);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(String.valueOf(threadName) + ": Locking world view.");
        }
        ((ILockableVisionWorldView)((UT2004Bot)this.agent).getWorldView()).lock();
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer(String.valueOf(threadName) + ": World view locked.");
        }
    }

    protected void afterLogic(String threadName) {
        super.afterLogic(threadName);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(String.valueOf(threadName) + ": Unlocking world view.");
        }
        ((ILockableVisionWorldView)((UT2004Bot)this.agent).getWorldView()).unlock();
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer(String.valueOf(threadName) + ": World view unlocked.");
        }
    }

    protected void afterLogicException(String threadName, Throwable e) {
        super.afterLogicException(threadName, e);
        if (((ILockableVisionWorldView)((UT2004Bot)this.agent).getWorldView()).isLocked()) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Unlocking world view.");
            }
            ((ILockableVisionWorldView)((UT2004Bot)this.agent).getWorldView()).unlock();
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view unlocked.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldExecuteLogic() {
        ICommandListener<Respawn> iCommandListener = this.respawnListener;
        synchronized (iCommandListener) {
            block5: {
                if (this.shouldExecuteLogicLatch == 0) break block5;
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Respawn command sensed - waiting for the bot respawn to execute logic with correct world view state.");
                }
                return false;
            }
            return true;
        }
    }
}

