/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.samples.AirScanner;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.Obstacle1;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.Record;
import cz.cuni.amis.pogamut.usar2004.samples.AirScanner.ToolBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class ScanPreview
extends JFrame {
    private int dataArrayXLimit;
    private int dataArrayYLimit;
    private int offsetX = 0;
    private int offsetY = 0;
    private final int extension = 400;
    private final int extLimit = 100;
    private final int border = 20;
    private final int infoPanelWidth = 280;
    private boolean datFile = false;
    private final int minWidth = 200;
    private final int minHeight = 350;
    int[] histogram = new int[256];
    double dMax = Double.MIN_VALUE;
    double dMin = Double.MAX_VALUE;
    public Point translate;
    public Record record;
    public Record recordPrev;
    Rotation rot;
    Rotation rotPrev;
    Location loc;
    Location locPrev;
    int offset = 0;
    List<Obstacle1> obstacles = new ArrayList<Obstacle1>();
    List<Location> robotPath = new ArrayList<Location>();
    List<Location> robotDiversions = new ArrayList<Location>();
    List<Location> robotRechargePoints = new ArrayList<Location>();
    List<Location> robotStartPoints = new ArrayList<Location>();
    List<Location> robotHighRiskPoints = new ArrayList<Location>();
    List<Location> robotLowRiskPoints = new ArrayList<Location>();
    Collection<Double> sonars;
    private String actInfo = "";
    private String postInfo = "";
    private final double rangeLimit = 19.9;
    private final int drawScale = 6;
    private final int panelWidth = 270;
    private final Point2D pos = new Point(135, 50);
    private final List<Double> highRisk = new ArrayList<Double>(){
        {
            this.add(0.47);
            this.add(0.61);
            this.add(0.86);
            this.add(1.22);
            this.add(1.5);
            this.add(1.22);
            this.add(0.86);
            this.add(0.61);
            this.add(0.47);
        }
    };
    private final List<Double> lowRisk = new ArrayList<Double>(){
        {
            this.add(1.57);
            this.add(1.91);
            this.add(2.72);
            this.add(3.5);
            this.add(4.5);
            this.add(3.5);
            this.add(2.72);
            this.add(1.91);
            this.add(1.57);
        }
    };
    private final int startSize = 500;
    BufferedImage tmp = new BufferedImage(500, 500, 2);
    Graphics2D tmpG = this.tmp.createGraphics();
    double[][] data;
    Image backBuffer;
    private int everyOther = 0;
    private JLabel jLabel1;

    public void runScanPreview() {
        this.setTitle("Scan Preview");
        this.setVisible(true);
    }

    public ScanPreview() {
        this.initComponents();
        this.data = ToolBox.initArray(500, 500);
        this.initBlackImage(this.tmp);
    }

    private boolean keepDataArrayGreat(int x, int y) {
        if (x > this.dataArrayXLimit) {
            this.tmp = ToolBox.resizeImage(this.tmp, 400, 0, 0, 0);
            this.tmpG = this.tmp.createGraphics();
            this.data = ToolBox.resizeArray(this.data, 400, 0, 0, 0);
            this.dataArrayXLimit = this.tmp.getWidth() - 100;
            return true;
        }
        if (x < this.tmp.getWidth() - this.dataArrayXLimit) {
            this.tmp = ToolBox.resizeImage(this.tmp, 400, 0, 400, 0);
            this.tmpG = this.tmp.createGraphics();
            this.data = ToolBox.resizeArray(this.data, 400, 0, 400, 0);
            this.dataArrayXLimit = this.tmp.getWidth() - 100;
            this.offsetX += 400;
            this.translate.x -= 400;
            return true;
        }
        if (y > this.dataArrayYLimit) {
            this.tmp = ToolBox.resizeImage(this.tmp, 0, 400, 0, 0);
            this.tmpG = this.tmp.createGraphics();
            this.data = ToolBox.resizeArray(this.data, 0, 400, 0, 0);
            this.dataArrayYLimit = this.tmp.getHeight() - 100;
            return true;
        }
        if (y < this.tmp.getHeight() - this.dataArrayYLimit) {
            this.tmp = ToolBox.resizeImage(this.tmp, 0, 400, 0, 400);
            this.tmpG = this.tmp.createGraphics();
            this.data = ToolBox.resizeArray(this.data, 0, 400, 0, 400);
            this.dataArrayYLimit = this.tmp.getHeight() - 100;
            this.offsetY += 400;
            this.translate.y -= 400;
            return true;
        }
        return false;
    }

    private void initBlackImage(BufferedImage tmp) {
        this.tmpG.setColor(Color.BLACK);
        this.tmpG.fillRect(0, 0, tmp.getWidth(), tmp.getHeight());
        this.offsetX = tmp.getWidth() / 2;
        this.offsetY = tmp.getHeight() / 2;
        this.dataArrayXLimit = tmp.getWidth() - 100;
        this.dataArrayYLimit = tmp.getHeight() - 100;
        this.translate = new Point(this.getWidth() / 2 - this.offsetX, this.getHeight() / 2 - this.offsetY);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Scan viewer");
        this.setBackground(new Color(51, 51, 51));
        this.setForeground(Color.white);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ScanPreview.this.formWindowClosing(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ScanPreview.this.formKeyPressed(evt);
            }
        });
        this.jLabel1.setBackground(new Color(255, 255, 255));
        this.jLabel1.setText("jLabel1");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(796, Short.MAX_VALUE).addComponent(this.jLabel1).addGap(227, 227, 227)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap(717, Short.MAX_VALUE)));
        this.pack();
    }

    private void formKeyPressed(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 37: {
                this.translate.x += 10;
                break;
            }
            case 39: {
                this.translate.x -= 10;
                break;
            }
            case 40: {
                this.translate.y -= 10;
                break;
            }
            case 38: {
                this.translate.y += 10;
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        File file;
        int counter = 0;
        File directory = new File(System.getProperty("user.home") + "\\Desktop\\USAR_Scans\\");
        do {
            if (!directory.exists()) {
                directory.mkdir();
            }
            file = new File(System.getProperty("user.home") + "\\Desktop\\USAR_Scans\\img" + (counter < 10 ? "0" + counter : Integer.valueOf(counter)) + ".png");
            ++counter;
        } while (file.exists());
        this.saveImage(this.createImage(file.getAbsolutePath()), file);
    }

    private int getDataLeftMargin() {
        for (int i = 20; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[i].length; ++j) {
                if (this.data[i][j] == Double.MIN_VALUE) continue;
                return i - 20;
            }
        }
        return this.data.length / 2;
    }

    private int getDataRightMargin() {
        for (int i = this.data.length - 20 - 1; i >= 0; --i) {
            for (int j = 0; j < this.data[i].length; ++j) {
                if (this.data[i][j] == Double.MIN_VALUE) continue;
                return i + 20;
            }
        }
        return this.data[0].length / 2;
    }

    private int getDataTopMargin() {
        for (int i = 20; i < this.data[0].length; ++i) {
            for (int j = 0; j < this.data.length; ++j) {
                if (this.data[j][i] == Double.MIN_VALUE) continue;
                return i - 20;
            }
        }
        return this.data.length / 2;
    }

    private int getDataBottomMargin() {
        for (int i = this.data[0].length - 20 - 1; i >= 0; --i) {
            for (int j = 0; j < this.data.length; ++j) {
                if (this.data[j][i] == Double.MIN_VALUE) continue;
                return i + 20;
            }
        }
        return this.data.length / 2;
    }

    private BufferedImage createImage(String path) {
        int left = this.getDataLeftMargin();
        int top = this.getDataTopMargin();
        int width = Math.max(this.getDataRightMargin() - left + 1, 200);
        int height = Math.max(this.getDataBottomMargin() - top + 1, 350);
        this.tmpG.drawRect(left, top, width - 1, height - 1);
        BufferedImage img = new BufferedImage(width + 280, height, 2);
        Graphics2D g = img.createGraphics();
        Graphics gr = g.create();
        gr.setColor(Color.BLACK);
        gr.fillRect(0, 0, img.getWidth(), img.getHeight());
        ByteBuffer buf = ByteBuffer.allocate((width + 1) * (height + 1) * 8);
        double shift = 0.0 - this.dMin;
        double scale = 255.0 / (shift + this.dMax / 2.0);
        for (int i = left; i < width + left; ++i) {
            for (int j = top; j < height + top; ++j) {
                if (this.data[i][j] == Double.MIN_VALUE) {
                    img.setRGB(i - left + 280, j - top, Color.BLACK.getRGB());
                } else {
                    img.setRGB(i - left + 280, j - top, this.convertToGray(this.data[i][j], shift, scale).getRGB());
                }
                if (!this.datFile) continue;
                buf.putDouble(this.data[i][j]);
            }
            if (!this.datFile) continue;
            buf.putDouble(Double.MAX_VALUE);
        }
        this.drawHistogram(g);
        this.drawRobotPath(g.create(), this.offsetX - left + 280, this.offsetY - top);
        this.drawControlPoints(g.create(), this.offsetX - left + 280, this.offsetY - top);
        this.drawLegend(g.create());
        if (this.datFile) {
            try {
                FileOutputStream ostream = new FileOutputStream(path.substring(0, path.length() - 3).concat("dat"), false);
                GZIPOutputStream str = new GZIPOutputStream(ostream);
                str.write(buf.array(), 0, buf.array().length);
                str.finish();
                str.close();
                ostream.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ScanPreview.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return img;
    }

    private void drawHistogram(Graphics2D g) {
        int max = ToolBox.getMax(this.histogram);
        g.setPaint(Color.GREEN);
        Rectangle2D.Double rect = new Rectangle2D.Double(9.0, 9.0, 257.0, 102.0);
        g.fill(rect);
        for (int i = 0; i < this.histogram.length; ++i) {
            int count = this.histogram[i];
            this.drawImageLine(i + 10, 10.0, i + 10, (double)count * 100.0 / (double)max + 10.0, new Color(i, i, i), g);
        }
    }

    private void drawLegend(Graphics g) {
        Location corner = new Location(20.0, 140.0);
        int spacing = 20;
        int yOffset = 0;
        this.drawStartPose(g, Location.ZERO, (int)corner.x, (int)corner.y + yOffset);
        this.drawString(g, "Landing/Recharging Point", (int)corner.x + spacing, (int)corner.y + yOffset);
        this.drawRechargePoint(g, Location.ZERO, (int)corner.x, (int)corner.y + (yOffset += 25));
        this.drawString(g, "Recharge Needed Location", (int)corner.x + spacing, (int)corner.y + yOffset);
        this.drawDiversion(g, Location.ZERO, (int)corner.x, (int)corner.y + (yOffset += 25));
        this.drawString(g, "Diversion Point", (int)corner.x + spacing, (int)corner.y + yOffset);
        this.drawHighRisk(g, Location.ZERO, (int)corner.x, (int)corner.y + (yOffset += 25));
        this.drawString(g, "HighRisk Situation", (int)corner.x + spacing, (int)corner.y + yOffset);
        this.drawLowRisk(g, Location.ZERO, (int)corner.x, (int)corner.y + (yOffset += 25));
        this.drawString(g, "LowRisk Situation", (int)corner.x + spacing, (int)corner.y + yOffset);
        this.drawPathDot(g, Location.ZERO, (int)corner.x, (int)corner.y + (yOffset += 25));
        this.drawString(g, "Robot Path Point", (int)corner.x + spacing, (int)corner.y + yOffset);
        g.setColor(Color.WHITE);
        this.drawData(g, (int)corner.x + spacing, (int)corner.y + (yOffset += 25));
    }

    private void drawData(Graphics g, int x, int y) {
        g.setColor(Color.WHITE);
        for (String line : this.postInfo.split("\n")) {
            g.drawString(line, x, y += g.getFontMetrics().getHeight());
        }
    }

    private void drawControlPoints(Graphics g, int offsetX, int offsetY) {
        for (Location location : this.robotRechargePoints) {
            this.drawRechargePoint(g, location, offsetX, offsetY);
        }
        for (Location location : this.robotDiversions) {
            this.drawDiversion(g, location, offsetX, offsetY);
        }
        for (Location location : this.robotStartPoints) {
            this.drawStartPose(g, location, offsetX, offsetY);
        }
        for (Location location : this.robotLowRiskPoints) {
            this.drawLowRisk(g, location, offsetX, offsetY);
        }
        for (Location location : this.robotHighRiskPoints) {
            this.drawHighRisk(g, location, offsetX, offsetY);
        }
    }

    private void drawRobotPath(Graphics g, int offsetX, int offsetY) {
        for (Location location : this.robotPath) {
            this.drawPathDot(g, location, offsetX, offsetY);
        }
    }

    public void saveImage(BufferedImage img, File outputfile) {
        try {
            if (outputfile.createNewFile()) {
                ImageIO.write((RenderedImage)img, "png", outputfile);
            } else {
                System.out.println("Couldnt creaate file");
            }
        }
        catch (IOException e) {
            System.out.println(e.getCause());
        }
    }

    private Color getScanColor(double range, int index) {
        if (index >= this.offset + 85 && index <= this.offset + 95) {
            return Color.MAGENTA;
        }
        if (range <= 19.9) {
            return Color.BLUE;
        }
        return Color.RED;
    }

    private void checkOffscreenImage() {
        Dimension d = this.getSize();
        if (this.backBuffer == null || this.backBuffer.getWidth(null) != d.width || this.backBuffer.getHeight(null) != d.height) {
            this.backBuffer = this.createImage(d.width, d.height);
        }
    }

    @Override
    public void paint(Graphics sharpGraphics) {
        Dimension d = this.getSize();
        this.checkOffscreenImage();
        Graphics backGraphics = this.backBuffer.getGraphics();
        backGraphics.setColor(this.getBackground());
        backGraphics.fillRect(0, 0, d.width, d.height);
        this.paintSituation(backGraphics);
        sharpGraphics.drawImage(this.backBuffer, 0, 0, null);
    }

    private void paintSituation(Graphics g) {
        if (this.recordPrev == null) {
            return;
        }
        g.drawImage(this.tmp, this.translate.x, this.translate.y, null);
        g.setColor(Color.white);
        g.fillRect(0, 0, 270, this.getSize().height);
        this.drawSonars(g);
        this.drawInfo(g, 20, 450);
        double angle = 90.0 + (this.record.getFOV() / 2.0 - this.rot.roll) * 180.0 / Math.PI;
        double anglePrev = 90.0 + (this.record.getFOV() / 2.0 - this.rotPrev.roll) * 180.0 / Math.PI;
        if (Math.abs(angle - anglePrev) > 180.0) {
            anglePrev *= -1.0;
        }
        for (int i = 0; i < this.record.getRanges().size(); ++i) {
            double range = this.record.getRanges().get(i);
            double rangePrev = this.recordPrev.getRanges().get(i);
            double value = range < 19.9 && rangePrev < 19.9 ? (range + rangePrev) / 2.0 : (range < 19.9 ? range : rangePrev);
            this.issueRay(g, i, range, angle, this.loc, this.rot);
            this.issueRay(g, i, value, (anglePrev + angle) / 2.0, this.getMidPoint(this.loc, this.locPrev), this.getMidTurn(this.rot, this.rotPrev));
            angle -= this.record.getFOV() / Math.PI * 180.0 / (double)this.record.getRanges().size() / 2.0;
            anglePrev -= this.recordPrev.getFOV() / Math.PI * 180.0 / (double)this.recordPrev.getRanges().size() / 2.0;
            if (i == 0) continue;
            range = (this.record.getRanges().get(i) + this.record.getRanges().get(i - 1)) / 2.0;
            rangePrev = (this.recordPrev.getRanges().get(i) + this.recordPrev.getRanges().get(i)) / 2.0;
            value = (range + rangePrev) / 2.0;
            this.issueRay(g, i - 1, range, angle -= this.record.getFOV() / Math.PI * 180.0 / (double)this.record.getRanges().size() / 2.0, this.loc, this.rot);
            this.issueRay(g, i - 1, value, ((anglePrev -= this.recordPrev.getFOV() / Math.PI * 180.0 / (double)this.recordPrev.getRanges().size() / 2.0) + angle) / 2.0, this.getMidPoint(this.loc, this.locPrev), this.getMidTurn(this.rot, this.rotPrev));
        }
        g.setColor(Color.GREEN);
    }

    public void issueRay(Graphics g, int index, double range, double angle, Location loc, Rotation rot) {
        double x = Math.cos(angle * Math.PI / 180.0) * range * 6.0;
        double y = Math.sin(angle * Math.PI / 180.0) * range * 6.0;
        double xOffset = Math.sin(rot.pitch) * y;
        double z = Math.cos(rot.pitch) * y;
        int height = (int)(loc.z * 6.0 - z + 60.0) * 255 / 20 / 6;
        Color c = this.getScanColor(range, index);
        this.drawLine(g, c, this.pos.getX(), this.pos.getY(), this.pos.getX() - x, this.pos.getY() + y);
        height = Math.max(height, 0);
        height = Math.min(height, 255);
        if (range <= 19.9) {
            this.drawLine(g, new Color(height, height, height), this.pos.getX() - x, 240.0, this.pos.getX() - x, 240.0 - (loc.z * 6.0 - z));
            this.drawPoint(this.tmpG, new Color(height, height, height), loc.x * 6.0 - Math.sin(rot.yaw) * x - Math.cos(rot.yaw) * xOffset + (double)this.offsetX, loc.y * 6.0 + Math.cos(rot.yaw) * x - Math.sin(rot.yaw) * xOffset + (double)this.offsetY);
            this.setDataAt(loc.x * 6.0 - Math.sin(rot.yaw) * x - Math.cos(rot.yaw) * xOffset + (double)this.offsetX, loc.y * 6.0 + Math.cos(rot.yaw) * x - Math.sin(rot.yaw) * xOffset + (double)this.offsetY, loc.z * 6.0 - z);
        }
    }

    private Location getMidPoint(Location locA, Location locB) {
        double x = locA.x + locB.x;
        double y = locA.y + locB.y;
        double z = locA.z + locB.z;
        return new Location(x / 2.0, y / 2.0, z / 2.0);
    }

    private double getMidAngle(double value1, double value2) {
        double val = value1 > 6.0 && value2 < 0.28 ? (value1 - Math.PI * 2 + value2) / 2.0 : (value2 > 6.0 && value1 < 0.28 ? (value2 - Math.PI * 2 + value1) / 2.0 : (value1 + value2) / 2.0);
        if (val < 0.0) {
            val += Math.PI * 2;
        }
        return val;
    }

    private Rotation getMidTurn(Rotation rotA, Rotation rotB) {
        double pitch = this.getMidAngle(rotA.pitch, rotB.pitch);
        double yaw = this.getMidAngle(rotA.yaw, rotB.yaw);
        double roll = this.getMidAngle(rotA.roll, rotB.roll);
        return new Rotation(pitch, yaw, roll);
    }

    private void drawInfo(Graphics g, int x, int y) {
        g.setColor(Color.BLACK);
        for (String line : this.actInfo.split("\n")) {
            g.drawString(line, x, y += g.getFontMetrics().getHeight());
        }
    }

    private Color convertToGray(double data, double offset, double scale) {
        int height = (int)((offset + data) * scale);
        height = Math.max(0, height);
        int n = height = Math.min(255, height);
        this.histogram[n] = this.histogram[n] + 1;
        return new Color(height, height, height);
    }

    private void setDataAt(double x, double y, double data) {
        if (data > this.dMax) {
            this.dMax = data;
        }
        if (data < this.dMin) {
            this.dMin = data;
        }
        this.data[(int)x][(int)y] = this.data[(int)x][(int)y] == Double.MIN_VALUE ? data : (this.data[(int)x][(int)y] + data) / 2.0;
    }

    private void drawString(Graphics g, String text, int x, int y) {
        g.drawChars(text.toCharArray(), 0, text.length(), x, y + g.getFontMetrics().getHeight() / 4);
    }

    private void drawDiversion(Graphics g, Location diversion, int offsetX, int offsetY) {
        g.setColor(Color.BLUE);
        g.fillRect((int)(diversion.x * 6.0 + (double)offsetX) - 2, (int)(diversion.y * 6.0 + (double)offsetY) - 2, 5, 5);
    }

    private void drawStartPose(Graphics g, Location startPose, int offsetX, int offsetY) {
        g.setColor(Color.MAGENTA);
        g.drawOval(offsetX + (int)(startPose.x * 6.0) - 10, offsetY + (int)(startPose.y * 6.0) - 10, 20, 20);
    }

    private void drawRechargePoint(Graphics g, Location rechargePoint, int offsetX, int offsetY) {
        g.setColor(Color.YELLOW);
        g.fillRect(offsetX + (int)(rechargePoint.x * 6.0) - 3, offsetY + (int)(rechargePoint.y * 6.0) - 3, 6, 6);
    }

    private void drawLowRisk(Graphics g, Location lowRisk, int offsetX, int offsetY) {
        g.setColor(Color.orange);
        g.drawOval(offsetX + (int)(lowRisk.x * 6.0) - 1, offsetY + (int)(lowRisk.y * 6.0) - 1, 3, 3);
    }

    private void drawHighRisk(Graphics g, Location highRisk, int offsetX, int offsetY) {
        g.setColor(Color.red);
        g.drawOval(offsetX + (int)(highRisk.x * 6.0) - 2, offsetY + (int)(highRisk.y * 6.0) - 2, 4, 4);
    }

    private void drawPathDot(Graphics g, Location dot, int offsetX, int offsetY) {
        g.setColor(Color.GREEN);
        g.fillOval(offsetX + (int)(dot.x * 6.0) - 1, offsetY + (int)(dot.y * 6.0) - 1, 3, 3);
    }

    private void drawSonars(Graphics g) {
        if (this.sonars == null) {
            return;
        }
        int count = 0;
        int scale = 258 / this.sonars.size();
        for (Double sonar : this.sonars) {
            if (sonar < this.highRisk.get(count)) {
                g.setColor(Color.red);
            } else if (sonar < this.lowRisk.get(count)) {
                g.setColor(Color.green);
            } else {
                g.setColor(Color.BLUE);
            }
            g.fillRect(12 + count * scale, 350, scale - 1, (int)(sonar * 6.0 * 2.0));
            ++count;
        }
    }

    private void drawImageLine(double x1, double y1, double x2, double y2, Color c, Graphics2D g) {
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        g.setColor(c);
        g.draw(line);
    }

    private void drawLine(Graphics g, Color c, double x1, double y1, double x2, double y2) {
        g.setColor(c);
        g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
    }

    private void drawPoint(Graphics g, Color c, double x, double y) {
        g.setColor(c);
        int xn = (int)x - this.offsetX;
        int yn = (int)y - this.offsetY;
        if (this.keepDataArrayGreat((int)x, (int)y)) {
            g.drawLine(xn + this.offsetX, yn + this.offsetY, xn + this.offsetX, yn + this.offsetY);
        } else {
            g.drawLine((int)x, (int)y, (int)x, (int)y);
        }
    }

    private void addObstacle(double x, double y) {
        for (Obstacle1 obstacle : this.obstacles) {
            Obstacle1 newObstacle;
            if (obstacle.isWithin(x, y)) {
                return;
            }
            if (!obstacle.canExtend() || (newObstacle = obstacle.tryExtend(x, y)) == null) continue;
            return;
        }
        this.obstacles.add(new Obstacle1(x, y));
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setSonars(Collection<Double> sonars) {
        this.sonars = sonars;
    }

    public void setDivPoint(Location diversion) {
        this.robotDiversions.add(diversion);
        this.drawDiversion(this.tmpG, diversion, this.offsetX, this.offsetY);
    }

    public void setStartLocation(Location start) {
        this.robotStartPoints.add(start);
        this.drawStartPose(this.tmpG, start, this.offsetX, this.offsetY);
    }

    public void setRechargeBreakPoint(Location breakPoint) {
        this.robotRechargePoints.add(breakPoint);
        this.drawRechargePoint(this.tmpG, breakPoint, this.offsetX, this.offsetY);
    }

    public void setHighRiskPoint(Location highRisk) {
        this.robotHighRiskPoints.add(highRisk);
        this.drawHighRisk(this.tmpG, highRisk, this.offsetX, this.offsetY);
    }

    public void setLowRiskPoint(Location lowRisk) {
        this.robotLowRiskPoints.add(lowRisk);
        this.drawLowRisk(this.tmpG, lowRisk, this.offsetX, this.offsetY);
    }

    public void setRecord(Record rec) {
        this.recordPrev = this.record;
        this.record = rec;
    }

    public void setPostInfo(String info) {
        this.postInfo = info;
    }

    public void setDatFile(boolean write) {
        this.datFile = write;
    }

    public void refreshGraphics() {
        this.update(this.getGraphics());
    }

    public void setInfo(String text) {
        this.actInfo = text;
    }

    public void setOrientation(Rotation rot) {
        this.rotPrev = this.rot;
        this.rot = rot;
    }

    public void setLocation(Location loc) {
        this.locPrev = this.loc;
        this.loc = loc;
        this.drawPathDot(this.tmpG, loc, this.offsetX, this.offsetY);
        if (this.everyOther > 10) {
            this.everyOther = 0;
            this.robotPath.add(loc);
        } else {
            ++this.everyOther;
        }
    }
}

