/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.samples.AirScanner;

import math.geom2d.Point2D;

public class Obstacle {
    public static final double obstacleSize = 1.0;
    public static final double joinDistance = 1.5;
    public static final double maxExtendRatio = 0.25;
    public static final double maxEdgeSize = 10.0;
    private Point2D corner;
    private double width;
    private double height;

    public Obstacle(Point2D corner, double width, double height) {
        this.corner = corner;
    }

    public Obstacle(Point2D center) {
        this(center.x, center.y);
    }

    public Obstacle(double centerX, double centerY) {
        this.corner = new Point2D(centerX - 0.5, centerY - 0.5);
        this.width = 1.0;
        this.height = 1.0;
    }

    private boolean extend(double x, double y) {
        boolean extended = false;
        if (this.corner.x > x - 1.0) {
            this.width += this.corner.x - (x - 1.0);
            this.corner.x = x - 1.0;
            extended = true;
        }
        if (this.corner.x + this.width < x + 1.0) {
            this.width = x + 1.0 - this.corner.x;
            extended = true;
        }
        if (this.corner.y > y - 1.0) {
            this.height += this.corner.y - (y - 1.0);
            this.corner.y = y - 1.0;
            extended = true;
        }
        if (this.corner.y + this.height < y + 1.0) {
            this.height = y + 1.0 - this.corner.y;
            extended = true;
        }
        return extended;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public Point2D getCorner() {
        return this.corner;
    }

    public Obstacle tryExtend(double x, double y) {
        if (x > this.corner.x - 1.5 && x < this.corner.x + this.width + 1.5 && y > this.corner.y - 1.5 && y < this.corner.y + this.height + 1.5) {
            this.extend(x, y);
            return this;
        }
        return null;
    }

    public boolean canExtend() {
        return !(0.25 * this.width < this.height) || !(0.25 * this.height < this.width) || !(this.width > 10.0) && !(this.height > 10.0);
    }

    public boolean isInside(double x, double y) {
        return x > this.corner.x && x < this.corner.x + this.width && y > this.corner.y && y < this.corner.y + this.height;
    }

    public static Obstacle MergeObstacles(Obstacle blockA, Obstacle blockB) {
        double xA = blockA.corner.x;
        double xB = blockB.corner.x;
        double yA = blockA.corner.y;
        double yB = blockB.corner.y;
        double xC = xA + blockA.width;
        double yC = yA + blockA.height;
        double xD = xB + blockB.width;
        double yD = yB + blockB.height;
        Point2D newCorner = new Point2D(Math.min(xA, xB), Math.min(yA, yB));
        double newWidth = Math.max(xC, xD) - newCorner.x;
        double newHeight = Math.max(yC, yD) - newCorner.y;
        return new Obstacle(newCorner, newWidth, newHeight);
    }
}

