/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes;

import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.GeographicCoordinates;

public class Longitude
extends GeographicCoordinates {
    public Longitude() {
    }

    public Longitude(int degree, double minute, char cardinal) {
        super(degree, minute, cardinal);
    }

    public static double DMCToMinutes(Longitude longitude) {
        double returnee = longitude.minute + (double)(longitude.degree * 60);
        return longitude.cardinal == 'W' ? -returnee : returnee;
    }

    public static Longitude MinutesTODMC(double minutes) {
        double minute = Math.abs(minutes % 60.0);
        int degree = Math.abs((int)minutes / 60);
        char cardinal = minutes < 0.0 ? (char)'W' : 'E';
        return new Longitude(degree, minute, cardinal);
    }

    public static double DMCToDegree(Longitude longitude) {
        double returnee = longitude.minute / 60.0 + (double)longitude.degree;
        return longitude.getCardinal() == 'W' ? -returnee : returnee;
    }

    public static Longitude DegreeToDMC(double degree) {
        int deg = (int)Math.abs(degree);
        double minute = (Math.abs(degree) - (double)deg) * 60.0;
        char cardinal = degree < 0.0 ? (char)'W' : 'E';
        return new Longitude(deg, minute, cardinal);
    }
}

