package cz.cuni.amis.pogamut.usar2004.factory.guice.remoteagent;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentFactory;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.params.USAR2004AgentParameters;


/**
 * Guice-base {@link IUT2004Bot} factory. It needs {@link UT2004BotModule} to work correctly and the module is required
 * to bound {@link IAgent} to the {@link IUT2004Bot}, otherwise the method {@link UT2004BotFactory#newAgent(IRemoteAgentParameters)}
 * will throw {@link ClassCastException}.
 * <p><p>
 * For more info about the factory, see {@link GuiceAgentFactory}.
 *
 * @author Jimmy
 *
 * @param <BOT>
 * @param <PARAMS>
 */
public class USAR2004BotFactory<BOT extends USAR2004Bot, PARAMS extends USAR2004AgentParameters> extends GuiceAgentFactory<BOT, PARAMS> {

	public USAR2004BotFactory(USAR2004BotModule<PARAMS> agentModule) {
		super(agentModule);
	}

	@Override
	protected USAR2004BotModule<PARAMS> getAgentModule() {
		return (USAR2004BotModule<PARAMS>) super.getAgentModule();
	}

}
