package cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages;

import java.util.*;
import cz.cuni.amis.pogamut.base.communication.worldview.event.*;
import cz.cuni.amis.pogamut.base.communication.translator.event.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * A State message is the message class that reports the robot or mission
 * package’s state. State message reports the robot's actual state. Please note
 * that the robot state message parameters depend on the type of robot that you
 * are driving. For example, a robot of type “GroundVehicle” will not have the
 * same state message as a robot of type “AerialVehicle.” A robot state message
 * looks like (for a ground vehicle): STA {Type string} {Time float} {FrontSteer
 * float} {RearSteer float}{LightToggle bool} {LightIntensity int} {Battery int}
 *
 * Corresponding GameBots message is STA.
 *
 */
public class StateMessage extends GBEvent implements IWorldEvent, IWorldChangeEvent
{
    public StateMessage(String Type, double Time, double FrontSteer, double RearSteer, double SternPlaneAngle, double RudderAngle, boolean LightToggle, int LightIntensity, int Battery)
    {
        this.Type = Type;
        this.Time = Time;
        this.FrontSteer = FrontSteer;
        this.RearSteer = RearSteer;
        this.SternPlaneAngle = SternPlaneAngle;
        this.RudderAngle = RudderAngle;
        this.LightToggle = LightToggle;
        this.LightIntensity = LightIntensity;
        this.Battery = Battery;
    }
    /**
     * Example how the message looks like - used during parser tests.
     */
    public static final String PROTOTYPE = "STA {Type text} {Time 0} {FrontSteer 0} {RearSteer 0} {SternPlaneAngle 0,0,0} {RudderAngle 0} {LightToggle False} {LightIntensity 0} {Battery 0}";
    /////// Properties BEGIN
    /**
     *
     * Type describes the vehicle type. It will be one of the following values:
     * "GroundVehicle”, “LeggedRobot”, “NauticVehicle”, or “AerialVehicle”.
     */
    protected String Type = null;

    /**
     * Type will be one of the following values: "GroundVehicle”, “LeggedRobot”,
     * “NauticVehicle”, or “AerialVehicle”.
     *
     * @return Returns Type of the vehicle.
     */
    public String getType()
    {
        return Type;
    }
    /**
     * Timestamp form the UT since server start in seconds.
     */
    protected double Time = 0;

    /**
     * Timestamp form the UT since server start in seconds.
     *
     * @return Returns seconds elapsed from the start of the server.
     */
    public double getTime()
    {
        return Time;
    }
    protected double FrontSteer = 0;

    /**
     * Note: parameter only available for robots of “GroundVehicle” type.
     * Current front steer angle of the robot, in radians.
     *
     * @return Returns front steer angle value
     */
    public double getFrontSteer()
    {
        return FrontSteer;
    }
    protected double RearSteer = 0;

    /**
     * Note: parameter only available for robots of “GroundVehicle” type.
     * Current rear steer angle of the robot, in radians.
     *
     * @return Returns rear steer angle value.
     */
    public double getRearSteer()
    {
        return RearSteer;
    }
    //protected Location SternPlaneAngle = null;
    protected double SternPlaneAngle = 0;

    /**
     * Note: parameter only available for robots of “NauticVehicle” type.
     * Current stern plane angle of the robot, in radians.
     *
     * @return Returns sern plane angle.
     */
    public double getSternPlaneAngle()
    {
        return SternPlaneAngle;
    }
    protected double RudderAngle = 0;

    /**
     * Note: parameter only available for robots of “NauticVehicle” type.
     * Current rudder angle of the robot, in radians.
     *
     * @return Returns rudder angle.
     */
    public double getRudderAngle()
    {
        return RudderAngle;
    }
    protected boolean LightToggle = false;

    /**
     * Indicate whether the headlight has been turned on.
     *
     * @return Returns wether the Headlight is on or not.
     */
    public boolean isLightToggle()
    {
        return LightToggle;
    }
    protected int LightIntensity = 0;

    /**
     * Light intensity of the headlight. Right now, it always is 100.
     *
     * @return Returns the intensity of the Headlight.
     */
    public int getLightIntensity()
    {
        return LightIntensity;
    }
    protected int Battery = 0;

    /**
     * Power state of the battery. It is the battery lifetime in second. It’s
     * the total time remaining for the robot to run.
     *
     * @return Returns remaining battery life.
     */
    public int getBattery()
    {
        return Battery;
    }
    //added-UT2004 aerial vehicle
    protected int View = 0;

    /**
     * This was added for UT2004 version. Represents number of views when
     * Multiview(Multiple Cameras) is used.
     *
     * @return Returns number of views if MultiView used, else -1;
     */
    public int getView()
    {
        return View;
    }
    //added-UT2004 kenaf
    protected Map<String, String> PartsValues = new HashMap<String, String>();

    /**
     * Kenaf robot uses these to describe state of its Flippers.
     *
     * @return Returns a map containing data about Kenafs flippers.
     */
    public Map<String, String> getPartsValues()
    {
        return PartsValues;
    }

    /**
     * Cloning constructor.
     */
    public StateMessage(StateMessage original)
    {
        this.Type = original.Type;
        this.Time = original.Time;
        this.FrontSteer = original.FrontSteer;
        this.RearSteer = original.RearSteer;
        this.SternPlaneAngle = original.SternPlaneAngle;
        this.RudderAngle = original.RudderAngle;
        this.LightToggle = original.LightToggle;
        this.LightIntensity = original.LightIntensity;
        this.Battery = original.Battery;
        this.View = original.View;
        this.PartsValues.putAll(original.PartsValues);
    }

    /**
     * Used by Yylex to create empty message then to fill it's protected fields
     * (Yylex is in the same package).
     */
    public StateMessage()
    {
    }

    @Override
    public String toString()
    {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString() + " | "
                + "Type = "
                + String.valueOf(Type) + " | "
                + "Time = "
                + String.valueOf(Time) + " | "
                + "FrontSteer = "
                + String.valueOf(FrontSteer) + " | "
                + "RearSteer = "
                + String.valueOf(RearSteer) + " | "
                + "SternPlaneAngle = "
                + String.valueOf(SternPlaneAngle) + " | "
                + "RudderAngle = "
                + String.valueOf(RudderAngle) + " | "
                + "LightToggle = "
                + String.valueOf(LightToggle) + " | "
                + "LightIntensity = "
                + String.valueOf(LightIntensity) + " | "
                + "Battery = "
                + String.valueOf(Battery) + " | "
                + "View = "
                + String.valueOf(View) + " | "
                + "");
        if(!PartsValues.isEmpty())
        {
            Iterator it = PartsValues.entrySet().iterator();
            while(it.hasNext())
            {
                Map.Entry en = (Map.Entry) it.next();
                buf.append(" ").append(en.getKey()).append(" ").append(en.getValue()).append(",");
            }
            buf.append(" | ");
        }

        return buf.toString();

    }

    /**
     * Gets all properties and values to create a HTML formated string;
     *
     * @return Returns all properties in HTML format
     */
    public String toHtmlString()
    {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString()
                + "<b>Type</b> : "
                + String.valueOf(Type)
                + " <br/> "
                + "<b>Time</b> : "
                + String.valueOf(Time)
                + " <br/> "
                + "<b>FrontSteer</b> : "
                + String.valueOf(FrontSteer)
                + " <br/> "
                + "<b>RearSteer</b> : "
                + String.valueOf(RearSteer)
                + " <br/> "
                + "<b>SternPlaneAngle</b> : "
                + String.valueOf(SternPlaneAngle)
                + " <br/> "
                + "<b>RudderAngle</b> : "
                + String.valueOf(RudderAngle)
                + " <br/> "
                + "<b>LightToggle</b> : "
                + String.valueOf(LightToggle)
                + " <br/> "
                + "<b>LightIntensity</b> : "
                + String.valueOf(LightIntensity)
                + " <br/> "
                + "<b>Battery</b> : "
                + String.valueOf(Battery)
                + " <br/> "
                + "<b>View</b> : "
                + String.valueOf(View)
                + " <br/> "
                + "");

        if(!PartsValues.isEmpty())
        {
            Iterator it = PartsValues.entrySet().iterator();
            while(it.hasNext())
            {
                Map.Entry en = (Map.Entry) it.next();
                buf.append("<b>").append(en.getKey()).append("</b> : ").append(en.getValue()).append(",");
            }
        }

        buf.append(" <br/> ");
        return buf.toString();
    }
}
