package cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages;

import java.util.*;
import cz.cuni.amis.pogamut.base.communication.worldview.event.*;
import cz.cuni.amis.pogamut.base.communication.translator.event.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.*;

/**
 *
 * When we connect to USARSim, we can send this command before spawning any
 * robot: GETSTARTPOSES.
 *
 * We will receive a string like this one: NFO {StartPoses 3} {BlueGoal
 * -2.55,-0.00,-0.19 0.00,-0.03,-0.01 MiddleField 0.01,- 0.00,-0.19
 * 0.00,0.00,0.00 YellowGoal 2.57,-0.01,-0.19 0.00,0.00,3.13}
 *
 * The syntax of this string doesn't follow strictly the USARSim standard.
 *
 * NFO message is also issued after connecting to the USARSIM server. And it
 * contains information about the level.
 *
 * Corresponding GameBots message is NFO.
 *
 */
public class NfoMessage extends GBEvent implements IWorldEvent, IWorldChangeEvent
{
    public NfoMessage(double TimeLimit, String Level, String GameType, int StartPoseCount)
    {
        this.TimeLimit = TimeLimit;
        this.Level = Level;
        this.GameType = GameType;
        this.StartPoseCount = StartPoseCount;
    }
    /**
     * Example how the message looks like - used during parser tests.
     */
    public static final String PROTOTYPE = "NFO {TimeLimit 0} {Level text} {GameType text} {StartPoseCount 0}";
    /////// Properties Info
//        /**
//        Timestamp form the GameBots. */
//        protected double Time = 0;
//        
//        public double getTime() {
//            return Time;
//        }
    protected String GameType = null;

    /**
     * Initial NFO message recieved from the server will provide information
     * such as Game Type.
     *
     * @return Returns a Unreal type of current game.
     */
    public String getGameType()
    {
        return GameType;
    }
    protected String Level = null;

    /**
     * Initial NFO message recieved from the server will provide information
     * such as Level Name.
     *
     * @return Returns name of current map.
     */
    public String getLevel()
    {
        return Level;
    }
    protected double TimeLimit = 0;

    /**
     * Initial NFO message recieved from the server will provide information
     * such as Time Limit.
     *
     * @return Returns the time limit for current map.
     */
    public double getTimeLimit()
    {
        return TimeLimit;
    }
    protected int StartPoseCount = 0;

    /**
     * StartPoseCount is the number of starting positions available. For every
     * starting position you'll be able to receive it's tag, location and
     * orientation:
     *
     * @return Returns number of availible start positions.
     */
    public int getStartPoseCount()
    {
        return StartPoseCount;
    }
    protected List<StartPose> StartPoses = new ArrayList<StartPose>();

    /**
     * GETSTARTPOSES will cause receipt of the NFO message with potencial
     * Locations for spawning a robot.
     *
     * @return Returns list of possible starting positions.
     */
    public List<StartPose> getStartPoses()
    {
        return StartPoses;
    }

    /**
     * Cloning constructor.
     */
    public NfoMessage(NfoMessage original)
    {
        this.TimeLimit = original.TimeLimit;
        this.GameType = original.GameType;
        this.Level = original.Level;
        this.StartPoseCount = original.StartPoseCount;
        this.StartPoses.addAll(original.StartPoses);
    }

    /**
     * Used by Yylex to create empty message then to fill it's protected fields
     * (Yylex is in the same package).
     */
    public NfoMessage()
    {
    }

    @Override
    public String toString()
    {
        StringBuilder buf = new StringBuilder();

        buf.append(super.toString() + " | "
                + "TimeLimit = "
                + String.valueOf(TimeLimit) + " | "
                + "GameType = "
                + String.valueOf(GameType) + " | "
                + "Level = "
                + String.valueOf(Level) + " | "
                + "StartPoseCount = "
                + String.valueOf(StartPoseCount) + " | ");

        if(!StartPoses.isEmpty())
        {
            for(StartPose startPose : StartPoses)
            {
                buf.append("Name").append(" = ").append(startPose.getName()).append(" ");
                buf.append("Position").append(" = ").append(startPose.getPosition().toString()).append(" ");
                buf.append("Orientation").append(" = ").append(startPose.getPosition().toString()).append(" ");
            }
            buf.append(" | ");
        }


        return buf.toString();

    }

    /**
     * Gets all properties and values to create a HTML formated string;
     *
     * @return Returns all properties in HTML format
     */
    public String toHtmlString()
    {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString()
                + "<b>TimeLimit</b> : "
                + String.valueOf(TimeLimit)
                + " <br/> "
                + "<b>GameType</b> : "
                + String.valueOf(GameType)
                + " <br/> "
                + "<b>Level</b> : "
                + String.valueOf(Level)
                + " <br/> "
                + "<b>StartPoseCount</b> : "
                + String.valueOf(StartPoseCount)
                + " <br/> ");
        if(!StartPoses.isEmpty())
        {
            for(StartPose startPose : StartPoses)
            {
                buf.append("<b>").append("Name").append("</b> : ").append(startPose.getName()).append(" <br/> ");
                buf.append("<b>").append("Position").append("</b> : ").append(startPose.getPosition()).append(" <br/> ");
                buf.append("<b>").append("Orientation").append("</b> : ").append(startPose.getOrientation()).append(" <br/> ");
            }
        }
        return buf.toString();
    }
}
