package cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages;

import java.util.*;
import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 * Serves for the purpose of testing the parser. Warning - first item in
 * PROTOTYPES is null!
 */
public class InfoMessages
{
    public static final String[] PROTOTYPES = new String[]
    {
        null // dummy
        , NfoMessage.PROTOTYPE,
        MissionPackageMessage.PROTOTYPE,
        SensorMessage.PROTOTYPE,
        StateMessage.PROTOTYPE,
        GeometryMessage.PROTOTYPE,
        ResponseMessage.PROTOTYPE,
        ConfigurationMessage.PROTOTYPE,
        KillMessage.PROTOTYPE
    };
    /**
     * Serves to initialize map
     */
    private static final Map<String, Class<? extends InfoMessage>> prototypeMap =
            new HashMap<String, Class<? extends InfoMessage>>();
    /**
     * Unmodifiable map message.PROTOTYPE -> message.class
     */
    public static final Map<String, Class<? extends InfoMessage>> PROTOTYPE_MAP;

    static
    {
        prototypeMap.put(NfoMessage.PROTOTYPE, NfoMessage.class);
        prototypeMap.put(MissionPackageMessage.PROTOTYPE, MissionPackageMessage.class);
        prototypeMap.put(SensorMessage.PROTOTYPE, SensorMessage.class);
        prototypeMap.put(StateMessage.PROTOTYPE, StateMessage.class);
        prototypeMap.put(GeometryMessage.PROTOTYPE, GeometryMessage.class);
        prototypeMap.put(ResponseMessage.PROTOTYPE, ResponseMessage.class);
        prototypeMap.put(ConfigurationMessage.PROTOTYPE, ConfigurationMessage.class);
        prototypeMap.put(KillMessage.PROTOTYPE, KillMessage.class);
        PROTOTYPE_MAP = Collections.unmodifiableMap(prototypeMap);
    }
}
