package cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands;

import java.util.*;
import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * This command is used to send a command to a camera.
 *
 *
 *
 * Corresponding GameBots command is SET.
 *
 */
public class SetCamera extends CommandMessage
{
    //constructor for the camera
    public SetCamera(String Type, String Name, Double FOV)
    {
        this.Type = Type;
        this.NamesFovs.put(Name, FOV);
    }

    //also constructor for the camera
    public SetCamera(String Type, String[] Names, Double[] FOVs)
    {
        this.Type = Type;
        if(Names.length == FOVs.length)
        {
            for(int i = 0; i < Names.length; i++)
            {
                this.NamesFovs.put(Names[i], FOVs[i]);
            }
        }
    }

    /**
     * <p></p>WARNING: this is empty-command constructor, you have to use
     * Setters to fill it up!
     */
    public SetCamera()
    {
    }
    /////// Properties BEGIN
    /*
     * NOTE: There is a difference between moving and controlling a camera.
     * Moving a camera (i.e. pan/tilt) is achieved by controlling the mission
     * package that the camera is attached to. Controlling a camera is used to
     * set its field of view.
     */
    protected String Type = "Camera";

    public String getType()
    {
        return Type;
    }
    Map<String, Double> NamesFovs = new HashMap<String, Double>();

    public Map<String, Double> getNamesFovs()
    {
        return NamesFovs;
    }

    public SetCamera setNamesFovs(Map<String, Double> NamesFovs)
    {
        this.NamesFovs = NamesFovs;
        return this;
    }

    public SetCamera addNameFOV(String Name, Double FOV)
    {
        this.NamesFovs.put(Name, FOV);
        return this;
    }

    /*
     * Example: SET {Type Camera} {Name Camera} {FOV 1} will set the field of
     * view of camera “Camera” to 1 radian. SET {Type Camera} {Name Camera} {FOV
     * 0} will set the field of view of camera “Camera” to its default field of
     * view.
     */
    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public SetCamera(SetCamera original)
    {
        this.NamesFovs.putAll(original.NamesFovs);
    }

    @Override
    public String toString()
    {
        return toMessage();
    }

    public String toHtmlString()
    {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());

        buf.append("<b>Type</b> : ").append(String.valueOf(Type)).append(" <br/> ");

        if(!NamesFovs.isEmpty())
        {

            Iterator it = NamesFovs.entrySet().iterator();
            while(it.hasNext())
            {
                Map.Entry en = (Map.Entry) it.next();
                buf.append("<b>Name</b> : ").append(en.getKey()).append("</br> <b>FOV</b> : ").append(en.getValue()).append("}");
            }
        }


        return buf.toString();

    }

    public String toMessage()
    {
        StringBuilder buf = new StringBuilder();
        buf.append("SET");

        if(Type != null)
        {
            buf.append(" {Type ").append(Type).append("}");
        }

        if(!NamesFovs.isEmpty())
        {

            Iterator it = NamesFovs.entrySet().iterator();
            while(it.hasNext())
            {
                Map.Entry en = (Map.Entry) it.next();
                buf.append(" {Name ").append(en.getKey()).append("} {FOV ").append(en.getValue()).append("}");
            }
        }

        return buf.toString();
    }
}
