package cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands;

import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * Drive command specified for a ground vehicle capable of stearing.
 *
 * Corresponding GameBots command is DRIVE.
 *
 */
public class DriveAckerman extends CommandMessage
{
    //constructor for the second type
    public DriveAckerman(double Speed, double FrontSteer, double RearSteer, boolean Normalized, boolean Light, boolean Flip)
    {
        this.Speed = Speed;
        this.FrontSteer = FrontSteer;
        this.RearSteer = RearSteer;
        this.Normalized = Normalized;
        this.Light = Light;
        this.Flip = Flip;
    }

    /**
     * <p></p>WARNING: this is empty-command constructor, you have to use
     * setters to fill it up!
     */
    public DriveAckerman()
    {
    }
    /////// Properties BEGIN
    //second type - Speed, FrontSteer, RearSteer, Normalized, Light, Flip
    /*
     * the spin speed for the wheels that are powered. If we use normalized
     * values, the value range is –100 to 100 and corresponds to the robot’s
     * minimum and maximum spin speed, respectively. Otherwise, the value is the
     * absolute spin speed, in radians per second.
     */
    protected double Speed = 0;

    public double getSpeed()
    {
        return Speed;
    }

    public DriveAckerman setSpeed(double Speed)
    {
        this.Speed = Speed;
        return this;
    }
    /*
     * the spin speed for the wheels that are powered. If we use normalized
     * values, the value range is –100 to 100 and corresponds to the robot’s
     * minimum and maximum spin speed, respectively. Otherwise, the value is the
     * absolute spin speed, in radians per second.
     */
    protected double FrontSteer = 0;

    public double getFrontSteer()
    {
        return FrontSteer;
    }

    public DriveAckerman setFrontSteer(double FrontSteer)
    {
        this.FrontSteer = FrontSteer;
        return this;
    }
    //Same as FrontSteer but for rear set of wheels.
    protected double RearSteer = 0;

    public double getRearSteer()
    {
        return RearSteer;
    }

    public DriveAckerman setRearSteer(double RearSteer)
    {
        this.RearSteer = RearSteer;
        return this;
    }
    /*
     * Indicates whether we are using normalized values or ´ * not. The default
     * value is ‘False’ which means absolute values are used to control wheel
     * spin speed.
     */
    protected boolean Normalized = false;

    public boolean isNormalized()
    {
        return Normalized;
    }

    public DriveAckerman setNormalized(boolean Normalized)
    {
        this.Normalized = Normalized;
        return this;
    }
    //Indicates whether to turn the headlight on or off
    protected boolean Light = false;

    public boolean isLight()
    {
        return Light;
    }

    public DriveAckerman setLight(boolean Light)
    {
        this.Light = Light;
        return this;
    }
    //Flip will flip the robot on its wheels if its rolled over
    protected boolean Flip = false;

    public boolean isFlip()
    {
        return Flip;
    }

    public DriveAckerman setFlip(boolean Flip)
    {
        this.Flip = Flip;
        return this;
    }

    /*
     * Example: DRIVE {Speed -1.0} will drive the robot backward with a spin
     * speed of 1 rad/sec. DRIVE {Speed 1.0} {FrontSteer 0.523599} will drive
     * the robot 30° forward and to the left with a spin speed of 1 rad/sec.
     * DRIVE {Speed 1.0} {FrontSteer -0.523599} will drive the robot 30° forward
     * and to the right with a spin speed of 1 rad/sec.
     */
    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public DriveAckerman(DriveAckerman original)
    {
        this.FrontSteer = original.FrontSteer;
        this.RearSteer = original.RearSteer;
        this.Speed = original.Speed;
        this.Normalized = original.Normalized;
        this.Flip = original.Flip;
        this.Light = original.Light;
    }

    @Override
    public String toString()
    {
        return toMessage();
    }

    public String toHtmlString()
    {
        return super.toString()
                + "<b>FrontSteer</b> : "
                + String.valueOf(FrontSteer)
                + " <br/> "
                + "<b>RearSteer</b> : "
                + String.valueOf(RearSteer)
                + " <br/> "
                + "<b>Speed</b> : "
                + String.valueOf(Speed)
                + " <br/> "
                + "<b>Normalized</b> : "
                + String.valueOf(Normalized)
                + " <br/> "
                + "<b>Light</b> : "
                + String.valueOf(Light)
                + " <br/> "
                + "<b>Flip</b> : "
                + String.valueOf(Flip)
                + " <br/> "
                + "";
    }

    public String toMessage()
    {

        StringBuilder buf = new StringBuilder();
        buf.append("DRIVE");
        buf.append(" {FrontSteer ").append(FrontSteer).append("}");
        buf.append(" {RearSteer ").append(RearSteer).append("}");
        buf.append(" {Speed ").append(Speed).append("}");
        buf.append(" {Normalized ").append(Normalized).append("}");
        buf.append(" {Light ").append(Light).append("}");
        buf.append(" {Flip ").append(Flip).append("}");

        return buf.toString();
    }
}
