package cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;

/**
 * Camera, Sensor and effecter mounts are composed from Name, Location,
 * Orientaion and Mount name. This Class is used to offer geometry information
 * composed from these atributes.
 *
 * @author vejmanm
 */
public class SensorMount
{
    private String Name = null;
    private Location Location = null;
    private Rotation Orientation = null;
    private String Mount = null;

    public SensorMount()
    {
    }

    public Location getLocation()
    {
        return Location;
    }

    /**
     *
     * @return Returns name of the base item that this item is mounted to.
     */
    public String getMount()
    {
        return Mount;
    }

    public String getName()
    {
        return Name;
    }

    public Rotation getOrientation()
    {
        return Orientation;
    }

    public void setLocation(Location loc)
    {
        this.Location = loc;
    }

    public void setLocation(double a, double b, double c)
    {
        this.Location = new Location(a, b, c);
    }

    public void setMount(String mount)
    {
        this.Mount = mount;
    }

    public void setName(String name)
    {
        this.Name = name;
    }

    public void setOrientation(Rotation orientation)
    {
        this.Orientation = orientation;
    }

    public void setOrientation(double x, double y, double z)
    {
        this.Orientation = new Rotation(x, y, z);
    }
}
