package cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes;

import java.io.Serializable;

/**
 * VALUE parameter has two possible meanings. If the link being described is a
 * prismatic joint, double gives the distance (in meters) from the original
 * position of the link. If the link being described is a revolute joint, it
 * gives a sector(probably).
 *
 * The TORQUE parameter gives the current torque of the link being described. *
 * All of the above are collected into one data structure below this text.
 *
 * @author vejmanm
 */
public class LinkState implements Serializable, Cloneable
{
    private int link = 0;
    private double value = 0;
    private double torque = 0;

    public LinkState()
    {
    }

    public LinkState(int link, double value, double torque)
    {
        this.link = link;
        this.value = value;
        this.torque = torque;
    }

    @Override
    public Object clone()
    {
        return new LinkState(link, value, torque);
    }

    public final void set(int link, double value, double torque)
    {
        this.link = link;
        this.value = value;
        this.torque = torque;

    }

    public final void set(LinkState tplLS)
    {
        link = tplLS.link;
        value = tplLS.value;
        torque = tplLS.torque;
    }

//            public final void get(LinkState tplLS) {
//                
//                tplLS.link=link;
//                tplLS.value=value;
//                tplLS.torque=torque;
//            }
    public final int getLink()
    {
        return link;
    }

    public final double getValue()
    {
        return value;
    }

    public final double getTorque()
    {
        return torque;
    }
}
