package cz.cuni.amis.pogamut.usar2004.agent.module.state;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.VehicleType;

/**
 * State message representative for Ground vehicle.
 *
 * @author vejmanm
 */
public class StateGround extends SuperState
{
    public static final VehicleType type = VehicleType.GROUND_VEHICLE;

    /**
     * Ctor. State type describes particular subject about which we want to know
     * about. It is used to distinguish incoming message from the server.
     */
    public StateGround()
    {
        super(type);
    }

    /**
     * Note: parameter only available for robots of “GroundVehicle” type.
     * Current front steer angle of the robot, in radians.
     *
     * @return Returns front steer angle value
     */
    public double getFrontSteer()
    {
        return lastMessage.getFrontSteer();
    }

    /**
     * Note: parameter only available for robots of “GroundVehicle” type.
     * Current rear steer angle of the robot, in radians.
     *
     * @return Returns rear steer angle value.
     */
    public double getRearSteer()
    {
        return lastMessage.getRearSteer();
    }
}
