package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.SensorMessage;

/**
 * It was initially abstract, but ctor with one parameter was inserted and now
 * this class is used not only as base class for sensor modules, but also as
 * class carrying elementary info about unknown sensors.
 *
 * @author vejmanm
 */
public /*
         * abstract
         */ class SuperSensor
{
    protected SensorMessage lastMessage;
    protected SensorType sensorType;

    /**
     * Ctor. Sensor type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public SuperSensor()
    {
        this(SensorType.UNKNOWN_SENSOR);
    }

    /**
     * Ctor.
     *
     * @param type Sensor type describes particular subject about which we want
     * to know about. It is used to distinguish incoming message from the
     * server.
     */
    protected SuperSensor(SensorType type)
    {
        this.sensorType = type;
    }

//    @Override
//    protected void cleanUp()
//    {
//        super.cleanUp();
//        bot=null;
//        lastMessage = null;
//        sensorType=null;
//    }
    /**
     * Method used for updating the message object that provides particular
     * properties for given type. Note that this object is created by yylex
     * parser and contains properties for all configuration subject types. But
     * only relevat to individual Sensor are filled.
     *
     * @param message Sensor message from server.
     */
    public void updateMessage(SensorMessage message)
    {
        //if(message.getType().equalsIgnoreCase(SensorType))
        lastMessage = message;
    }

    /**
     * Timestamp form the UT since server start in seconds. Note that time is
     * optional parameter.
     *
     * @return Returns seconds elapsed from the start of the server.
     */
    public double getTime()
    {
        return lastMessage.getTime();
    }

    /**
     * Used to make sure the object is filled.
     *
     * @return Returns true if the object is filled with sen. message.
     */
    public Boolean isReady()
    {
        return (lastMessage != null);
    }

    /**
     * Type describes the sensor type. It will be one of the following values:
     * "RFID”, “RangeScanner”, “IR”, "IRScanner", "Tachometer", "Helper",
     * "Sonar", "Odometry", "GPS", "INS", "INU", "Encoder", "Touch",
     * "VictSensor","HumanMotion", "Sound" or "GroundTruth".
     *
     * @return Type of the sensor.
     */
    public String getType()
    {
        return lastMessage.getType();
    }

    /**
     * SensorType is a descriptor used for creating particular instance and for
     * getting type information about particular sensor.
     *
     * @return Returns SensorType.
     */
    public SensorType getSensorType()
    {
        return sensorType;
    }

    /**
     * Name of the sensor.
     *
     * @return Returns name of the sensor
     */
    public String getName()
    {
        return lastMessage.getName();
    }
}
///*
// * To change this template, choose Tools | Templates
// * and open the template in the editor.
// */
//package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;
//
//import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
//import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
//import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
//import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
//import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.SensorMessage;
//
///**
// *
// * @author vejmanm
// */
//public abstract class SuperSensor extends SensorModule<USAR2004Bot>
//{
//
//    protected SensorMessageListener sensorListener;
//
//    public SuperSensor(USAR2004Bot bot, String type)
//    {
//        super(bot);
//        this.bot = bot;
//
//        sensorListener = new SensorMessageListener(worldView, type);
//    }
//
//    private class SensorMessageListener implements IWorldEventListener<SensorMessage>
//    {
//
//        @Override
//        public void notify(SensorMessage event)
//        {
//            //rfidsensor uses null
//            if(type == null || event.getType().equalsIgnoreCase(type))
//                lastMessage = event;
//        }
//        private String type = null;
//
//        public SensorMessageListener(IWorldView worldView, String type)
//        {
//            this.type = type;
//            worldView.addEventListener(SensorMessage.class, this);
//        }
//    }
//}
