package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;

import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;
import java.util.Map;
import java.util.Set;

/**
 * Sensor message representative for Touch sensor.
 *
 * @author vejmanm
 */
public class SensorTouch extends SuperSensor
{
    //public static final String type="Touch";
    public static final SensorType type = SensorType.TOUCH_SENSOR;

    /**
     * Ctor. Sensor type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public SensorTouch()
    {
        super(type);
    }

    /**
     * String is the sensor name. Boolean indicates whether the sensor is
     * touching something. Value ‘True’ means the sensor is touching something.
     *
     * @param Name String representation of touch sensor name.
     * @return Returns Boolean value matching <B>Name</B>.
     */
    public boolean getTouchByName(String Name)
    {
        return lastMessage.getTouches().get(Name);
    }

    /**
     * String is the sensor name. Boolean indicates whether the sensor is
     * touching something. Value ‘True’ means the sensor is touching something.
     *
     * @return Returns KeySet of Touch Map.
     */
    public Set<String> getTouchNames()
    {
        return lastMessage.getTouches().keySet();
    }

    /**
     * Returns size of touch map.
     *
     * @return Returns size of touch map.
     */
    public int getTouchesSize()
    {
        return lastMessage.getTouches().size();
    }

    /**
     * String is the sensor name. Boolean indicates whether the sensor is
     * touching something. Value ‘True’ means the sensor is touching something.
     *
     * @return Returns map of touch names and values.
     */
    private Map<String, Boolean> getTouches()
    {
        return lastMessage.getTouches();
    }
}
