package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;
import javax.vecmath.Point4d;

/**
 * Sensor message representative for Tachometer sensor.
 *
 * @author vejmanm
 */
public class SensorTachometer extends SuperSensor
{
    //public static final String type="Tachometoer";
    public static final SensorType type = SensorType.TACHOMETER;

    /**
     * Ctor. Sensor type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public SensorTachometer()
    {
        super(type);
    }

    /**
     * Velocity of the robot measured by Tachometer. Not in the USARSim manual
     * v3.1.3.
     *
     * @return Returns velocity from Tachometer.
     */
    public Point4d getVelocity()
    {
        return lastMessage.getVelocity();
    }

    /**
     * Position of the robot measured by Tachometer. Not in the USARSim manual
     * v3.1.3.
     *
     * @return Returns position from Tachometer.
     */
    public Point4d getPosition()
    {
        //NOTE - really? tach has this property?
        return lastMessage.getPosition();
    }
}
