package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;

/**
 * Sensor message representative for Sound sensor.
 *
 * @author vejmanm
 */
public class SensorSound extends SuperSensor
{
    //public static final String type="Sound";
    public static final SensorType type = SensorType.SOUND_SENSOR;

    /**
     * Ctor. Sensor type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public SensorSound()
    {
        super(type);
    }

    /**
     * Loudnes from the sound sensor.
     *
     * @return Returns loundness of a sound.
     */
    public double getLoudness()
    {
        return lastMessage.getLoudness();
    }

    /**
     * Duration of a sound from the sound sensor.
     *
     * @return Returns a drutaion of a sound.
     */
    public double getDuration()
    {
        return lastMessage.getDuration();
    }
}
