package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;
import java.util.Map;
import java.util.Set;

/**
 * Sensor message representative for Range sensor.
 *
 * @author vejmanm
 */
public class SensorRange extends SuperSensor
{
    //public static final String type="Sonar";
    public static final SensorType type = SensorType.RANGE_SENSOR;

    /**
     * Ctor. Sensor type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public SensorRange()
    {
        super(type);
    }

    /**
     * Map indexed by string is used to collect data of range sensor. ‘Dtring’
     * is the sensor name, ‘Double’ is the range value in meters.
     *
     * @param Name String representation of Range Name.
     * @return Returns range from range sensor(Sonar) matching input
     * <b>Name</b>.
     */
    public double getRangeByName(String Name)
    {
        return lastMessage.getRangeRanges().get(Name);
    }

    /**
     * Map indexed by string is used to collect data of range sensor. ‘Dtring’
     * is the sensor name, ‘Double’ is the range value in meters.
     *
     * @return Returns Keyset of the map representing names of range ranges.
     */
    public Set<String> getRangeNames()
    {
        return lastMessage.getRangeRanges().keySet();
    }

    /**
     * Returns size of Ranges.
     *
     * @return Returns size of Ranges.
     */
    public int getSize()
    {
        return lastMessage.getRangeRanges().size();
    }

    /**
     * Map indexed by string is used to collect data of range sensor. ‘Dtring’
     * is the sensor name, ‘Double’ is the range value in meters.
     *
     * @return Returns Map of ranges from range sensor(Sonar).
     */
    public Map<String, Double> getRanges()
    {
        return lastMessage.getRangeRanges();
    }
}
