package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.Latitude;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.Longitude;

/**
 *
 * @author vejmanm
 */
public class SensorGPS extends SuperSensor
{
    //public static final String type="GPS";
    public static final SensorType type = SensorType.GPS_SENSOR;

    /**
     * Ctor. Sensor type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public SensorGPS()
    {
        super(type);
    }

    /**
     * ‘int’, ’double’, ’char’ provide the latitude degree, minute (as a
     * decimal), and cardinal description (i.e. ‘N’ or ‘S’), respectively. There
     * are only two possible values for the ‘char’ parameter: ‘N’ for North and
     * ‘S’ for South.
     *
     * @return Returns Latitude value of the sensor.
     */
    public Latitude getLatitude()
    {
        return lastMessage.getLatitude();
    }

    /**
     * ‘int’, ’float’, ’char’ provide the longitude degree, minute (as a
     * decimal), and cardinal description (i.e. ‘E’ or ‘W’), respectively. There
     * are only two possible values for the ‘char’ parameter: ‘E’ for East and
     * ‘W’ for West.
     *
     * @return Returns Longitude value of the sensor.
     */
    public Longitude getLongitude()
    {
        return lastMessage.getLongitude();
    }

    /**
     * ‘int’ indicates whether or not a position was acquired. The fix is the
     * same as the GGA format. Namely, a value of 0 means that the GPS sensor
     * failed to acquire a position and a value of 1 means that a position was
     * acquired.
     *
     * @return Returns 0 - failed to acquire a position or 1 - success.
     */
    public int getFix()
    {
        return lastMessage.getFix();
    }

    /**
     * ‘int’ gives the number of satellites tracked by the GPS sensor. This
     * number is an inexplicit source of accuracy. The more satellites are
     * tracked, the higher the position accuracy.
     *
     * @return Returns number of active GPS satellite connections.
     */
    public int getSatellites()
    {
        return lastMessage.getSatellites();
    }
}
