package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;

/**
 *
 * Sensor message representative for Victim sensor.
 *
 * @author vejmanm
 */
public class SensorAcceleration extends SuperSensor
{
    public static final SensorType type = SensorType.ACCELERATION_SENSOR;

    /**
     * Ctor. Sensor type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public SensorAcceleration()
    {
        super(type);
    }

    /**
     * Acceleration from Acceleration Sensor. Not in USARSim manual v3.1.3.
     *
     * @return Returns acceleration from accel sensor.
     */
    public Velocity getAcceleration()
    {
        return lastMessage.getAcceleration();
    }
}
