package cz.cuni.amis.pogamut.usar2004.agent.module.geometry;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.GeometryType;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.SensorMount;
import java.util.List;

/**
 * Geometry message representative for Sensors and Effecters.
 *
 * @author vejmanm
 */
public class GeoSensorEffecter extends SuperGeometry
{
    public static final GeometryType type = GeometryType.SENSOR_EFFECTER;

    /**
     * Ctor. Geometry type describes particular subject about which we
     * want to know about. It is used to distinguish incoming message from the
     * server.
     */
    public GeoSensorEffecter()
    {
        super(type);
    }

    /**
     * Returns size of collection of sensor mounts.
     *
     * @return Returns size of collection of sensor mounts.
     */
    public int getSize()
    {
        return lastMessage.getSenEffGeo().size();
    }

    /**
     * Camera, Sensor and effecter mounts are composed from Name, Location,
     * Orientaion and Mount name. Returns null if none matches.
     *
     * Example: GEO {Type Camera} {Name Camera Location 0.0820,0.0002,0.0613
     * Orientation 0.0000,-0.0000,0.0000 Mount CameraTilt}
     *
     * @return Returns a Lotaion of sensor mount matching input <b>Name</b>.
     */
    public Location getLocationBy(String Name)
    {
        SensorMount sen = getSensorEffecterBy(Name);
        if(sen == null)
        {
            return null;
        }
        return sen.getLocation();
    }

    /**
     * Camera, Sensor and effecter mounts are composed from Name, Location,
     * Orientaion and Mount name. Returns null if none matches.
     *
     * Example: GEO {Type Camera} {Name Camera Location 0.0820,0.0002,0.0613
     * Orientation 0.0000,-0.0000,0.0000 Mount CameraTilt}
     *
     * @return Returns a Location of sensor mount at given index.
     */
    public Location getLocationAt(int index)
    {
        SensorMount sen = getSensorEffecterAt(index);
        if(sen == null)
        {
            return null;
        }
        return sen.getLocation();
    }

    /**
     * Camera, Sensor and effecter mounts are composed from Name, Location,
     * Orientaion and Mount name. Returns null if none matches.
     *
     * Example: GEO {Type Camera} {Name Camera Location 0.0820,0.0002,0.0613
     * Orientation 0.0000,-0.0000,0.0000 Mount CameraTilt}
     *
     * @return Returns a Mount name of sensor mount matching input <b>Name</b>.
     */
    public String getMountBy(String Name)
    {
        SensorMount sen = getSensorEffecterBy(Name);
        if(sen == null)
        {
            return null;
        }
        return sen.getMount();
    }

    /**
     * Camera, Sensor and effecter mounts are composed from Name, Location,
     * Orientaion and Mount name. Returns null if none matches.
     *
     * Example: GEO {Type Camera} {Name Camera Location 0.0820,0.0002,0.0613
     * Orientation 0.0000,-0.0000,0.0000 Mount CameraTilt}
     *
     * @return Returns a Mount name of sensor mount at given index.
     */
    public String getMountAt(int index)
    {
        SensorMount sen = getSensorEffecterAt(index);
        if(sen == null)
        {
            return null;
        }
        return sen.getMount();
    }

    /**
     * Camera, Sensor and effecter mounts are composed from Name, Location,
     * Orientaion and Mount name. Returns null if none matches.
     *
     * Example: GEO {Type Camera} {Name Camera Location 0.0820,0.0002,0.0613
     * Orientation 0.0000,-0.0000,0.0000 Mount CameraTilt}
     *
     * @return Returns an orientation of sensor mount matching input
     * <b>Name</b>.
     */
    public Rotation getOrientationBy(String Name)
    {
        SensorMount sen = getSensorEffecterBy(Name);
        if(sen == null)
        {
            return null;
        }
        return sen.getOrientation();
    }

    /**
     * Camera, Sensor and effecter mounts are composed from Name, Location,
     * Orientaion and Mount name. Returns null if none matches.
     *
     * Example: GEO {Type Camera} {Name Camera Location 0.0820,0.0002,0.0613
     * Orientation 0.0000,-0.0000,0.0000 Mount CameraTilt}
     *
     * @return Returns an orientation of sensor mount at given index.
     */
    public Rotation getOrientationAt(int index)
    {
        SensorMount sen = getSensorEffecterAt(index);
        if(sen == null)
        {
            return null;
        }
        return sen.getOrientation();
    }

    /**
     * Camera, Sensor and effecter mounts are composed from Name, Location,
     * Orientaion and Mount name.
     *
     * Example: GEO {Type Camera} {Name Camera Location 0.0820,0.0002,0.0613
     * Orientation 0.0000,-0.0000,0.0000 Mount CameraTilt}
     *
     * @return Returns a sensor mount matching an input <b>Name</b>.
     */
    public SensorMount getSensorEffecterBy(String Name)
    {
        for(SensorMount item : lastMessage.getSenEffGeo())
        {
            if(item.getName().equalsIgnoreCase(Name))
            {
                return item;
            }
        }
        return null;
    }

    /**
     * Camera, Sensor and effecter mounts are composed from Name, Location,
     * Orientaion and Mount name.
     *
     * Example: GEO {Type Camera} {Name Camera Location 0.0820,0.0002,0.0613
     * Orientation 0.0000,-0.0000,0.0000 Mount CameraTilt}
     *
     * @return Returns a sensor mount at given index.
     */
    public SensorMount getSensorEffecterAt(int index)
    {
        if(index < getSize())
        {
            return lastMessage.getSenEffGeo().get(index);
        }
        return null;
    }

    /**
     * Camera, Sensor and effecter mounts are composed from Name, Location,
     * Orientaion and Mount name.
     *
     * Example: GEO {Type Camera} {Name Camera Location 0.0820,0.0002,0.0613
     * Orientation 0.0000,-0.0000,0.0000 Mount CameraTilt}
     *
     * @return Returns a collection of sensor mounts.
     */
    public List<SensorMount> getSensorMountCollection()
    {
        return lastMessage.getSenEffGeo();
    }
}
