package cz.cuni.amis.pogamut.usar2004.agent.module.geometry;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.GeometryType;

/**
 * Geometry message representative for Mission package.
 *
 * @author vejmanm
 */
public class GeoMissionPackage extends SuperGeometry
{
    public static final GeometryType type = GeometryType.MISSION_PACKAGE;

    /**
     * Ctor. Geometry type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public GeoMissionPackage()
    {
        super(type);
    }

    /**
     * Returns length of link list.
     *
     * @return Returns length of link list.
     */
    public int getLinkSize()
    {
        return lastMessage.getLinks().size();
    }

    /**
     * Returns length of parent link list.
     *
     * @return Returns length of parent link list.
     */
    public int getParentLinkSize()
    {
        return lastMessage.getParentLinks().size();
    }

    /**
     * Returns length of location list.
     *
     * @return Returns length of loacation list.
     */
    public int getLocationSize()
    {
        return lastMessage.getLocations().size();
    }

    /**
     * Returns length of orientation list.
     *
     * @return Returns length of orientation list.
     */
    public int getOrientationsSize()
    {
        return lastMessage.getOrientations().size();
    }

    /**
     * For a mission package, the geometry message is expressed in the following
     * format to tell us how the mission package and its elements are
     * ‘installed’ together to the robot.
     *
     * Example: GEO {Type MisPkg} {Name CameraPanTilt} {Link 1} {ParentLink -1}
     * {Location 0.1239,0.0000,-0.2036} {Orientation 3.1415,0.0000,0.0000} {Link
     * 2} {ParentLink 1} {Location 0.0000,0.0000,0.0599} {Orientation
     * 1.5707,0.0000,0.0000}
     *
     * @return Returns mission package link at given index.
     */
    public int getLinkAt(int index)
    {
        if(index < getLinkSize())
        {
            return lastMessage.getLinks().get(index);
        }
        return -1;
    }

    /**
     * For a mission package, the geometry message is expressed in the following
     * format to tell us how the mission package and its elements are
     * ‘installed’ together to the robot.
     *
     * Example: GEO {Type MisPkg} {Name CameraPanTilt} {Link 1} {ParentLink -1}
     * {Location 0.1239,0.0000,-0.2036} {Orientation 3.1415,0.0000,0.0000} {Link
     * 2} {ParentLink 1} {Location 0.0000,0.0000,0.0599} {Orientation
     * 1.5707,0.0000,0.0000}
     *
     * @return Returns mission package parent link at given index.
     */
    public int getParentLink(int index)
    {
        if(index < getParentLinkSize())
        {
            return lastMessage.getParentLinks().get(index);
        }
        return -1;
    }

    /**
     * For a mission package, the geometry message is expressed in the following
     * format to tell us how the mission package and its elements are
     * ‘installed’ together to the robot.
     *
     * Example: GEO {Type MisPkg} {Name CameraPanTilt} {Link 1} {ParentLink -1}
     * {Location 0.1239,0.0000,-0.2036} {Orientation 3.1415,0.0000,0.0000} {Link
     * 2} {ParentLink 1} {Location 0.0000,0.0000,0.0599} {Orientation
     * 1.5707,0.0000,0.0000}
     *
     * @return Return mission mackage Location at given index.
     */
    public Location getLocationAt(int index)
    {
        if(index < getLocationSize())
        {
            return lastMessage.getLocations().get(index);
        }
        return null;
    }

    /**
     * For a mission package, the geometry message is expressed in the following
     * format to tell us how the mission package and its elements are
     * ‘installed’ together to the robot.
     *
     * Example: GEO {Type MisPkg} {Name CameraPanTilt} {Link 1} {ParentLink -1}
     * {Location 0.1239,0.0000,-0.2036} {Orientation 3.1415,0.0000,0.0000} {Link
     * 2} {ParentLink 1} {Location 0.0000,0.0000,0.0599} {Orientation
     * 1.5707,0.0000,0.0000}
     *
     * @return Returns mission package Orientation at given index.
     */
    public Rotation getOrientationAt(int index)
    {
        if(index < getOrientationsSize())
        {
            return lastMessage.getOrientations().get(index);
        }
        return null;
    }
}
