/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.usar2004.agent.module.configuration;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.ConfigType;

/**
 * Configuration for Vehicles - Ground, Aerial, Legged and Nautic share
 * properties present here.
 *
 * @author vejmanm
 */
public abstract class VehicleConfiguration extends SuperConfiguration
{
    /**
     * Ctor.
     *
     * @param type Configuration type describes particular subject about which
     * we want to know about. It is used to distinguish incoming message from
     * the server.
     */
    public VehicleConfiguration(ConfigType type)
    {
        super(type);
    }

    /**
     * Value should be one of the following: “AckermanSteered” or “SkidSteered”
     * or “OmniDrive”, as dictated by the steering type of the robot.
     *
     * @return Returns steering type of the robot.
     */
    public String getSteeringType()
    {
        return lastMessage.getSteeringType();
    }

    /**
     * It is the robot's mass in kg.
     *
     * @return Returns mass of the robot.
     */
    public double getMass()
    {
        return lastMessage.getMass();
    }
}
