package cz.cuni.amis.pogamut.usar2004.agent.module.configuration;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.ConfigType;

/**
 * Configuration message representative for Effecters.
 *
 * @author vejmanm
 */
public class ConfigEffecter extends SuperConfiguration
{
    public static final ConfigType type = ConfigType.EFFECTER;

    /**
     * Ctor. Configuration type describes particular subject about which we want
     * to know about. It is used to distinguish incoming message from the
     * server.
     */
    public ConfigEffecter()
    {
        super(type);
    }

    /**
     * For an effector, the configuration message can contain multiple OpCodes.
     * Opcode value is the name of the opcode that the effecter implements.
     * Refer to Section 8 of USARSim Manual v3.1.3 for a list of the opcodes.
     *
     * NOTE: An effecter can implement more than one opcode and the CONF message
     * returns the configuration information for all effecters on the robotic
     * platform. Therefore the segment with the name value pair indicates a new
     * effecter and the opcode name value pair indicates the opcode the effecter
     * specified in by name implements.
     *
     * @param index
     * @return Returns Operation Code at given index.
     */
    public String getOpcodeAt(int index)
    {
        if(index < getOpcodesLength())
        {
            return lastMessage.getOpcodes().get(index);
        }
        return null;
    }

    /**
     * It is value that indicates the upper bound for the value that is accepted
     * by the effecter.
     *
     * @param index
     * @return Returns Max value at given index.
     */
    public double getMaxValueAt(int index)
    {
        if(index < getOpcodesLength())
        {
            return lastMessage.getMaxVals().get(index);
        }
        return -1;
    }

    /**
     * It is value that indicates the lower bound for the value that is accepted
     * by the effecter.
     *
     * @param index
     * @return Returns Minx value at given index.
     */
    public double getMinValueAt(int index)
    {
        if(index < getOpcodesLength())
        {
            return lastMessage.getMinVals().get(index);
        }
        return -1;
    }

    /**
     * Returns length of Opcode list.
     *
     * @return Returns length of Opcode list.
     */
    public int getOpcodesLength()
    {
        return lastMessage.getOpcodes().size();
    }

    /**
     * Returns lenght of Minimal values list.
     *
     * @return Returns lenght of Minimal values list.
     */
    public int getMinValsLength()
    {
        return lastMessage.getMinVals().size();
    }

    /**
     * Returns lenght of Maximal values list.
     *
     * @return Returns lenght of Maximal values list.
     */
    public int getMaxValsLength()
    {
        return lastMessage.getMaxVals().size();
    }
}
