/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.usar2004.agent;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.agent.AbstractAgent3D;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.usar2004.agent.params.USAR2004AgentParameters;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.GetStartPoses;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.NfoMessage;
import cz.cuni.amis.utils.exception.PogamutException;

/**
 *
 * @author vejmanm
 */
@AgentScoped
public class USAR2004Bot<WORLD_VIEW extends IVisionWorldView, ACT extends IAct, CONTROLLER extends IUSAR2004BotController> extends AbstractAgent3D<WORLD_VIEW, ACT> implements IUSAR2004Bot {

    IUSAR2004BotController controller;

    boolean bRobotInitializedCalled = false;

    @Override
    public Location getLocation() {
        return null;
    }

    @Override
    public Velocity getVelocity() {
        return null;
    }

    @Override
    public Rotation getRotation() {
        return null;
    }

    @Override
    public void respawn() throws PogamutException {
    }
    // -----------------------
    // -=-=-=-=-=-=-=-=-=-=-=-
    // NFO MESSAGE LISTENER
    // -=-=-=-=-=-=-=-=-=-=-=-
    // -----------------------
    /**
     * Listener that is hooked to WorldView awaiting first event NfoMessage calling
     * robotInitialized method upon receiving the event.
     */
    private IWorldEventListener<NfoMessage> firstNfoMessageListener =
            new IWorldEventListener<NfoMessage>() {
                @Override
                public void notify(NfoMessage event) {
                    //setState(new BotStateInited("InitedMessage received, calling botInitialized()."));
                    if (!bRobotInitializedCalled) 
                    {
                        if(isStartPoseMessage(event))
                        {
                            controller.robotInitialized(event);
                            /** dereferencing listener */
                            getWorldView().removeEventListener(NfoMessage.class, this);
                            USAR2004Bot.this.firstNfoMessageListener = null;
                            bRobotInitializedCalled = true;                        
                        }
                        else
                        {
                            getAct().act(new GetStartPoses());
                            //To be able to obtain name of the map or game mode eventually time limit in the logic, we need to 
                            //remove this part or create another method that will trigger before robotInitialized() and call it here.
                        }                            
                    }
                    //setState(new BotStateInited("Bot initialized."));
                }
                /**
                 * This method is used to recognise if the NFO message is the first with level info or if it bears data about start poses.
                 */
                private boolean isStartPoseMessage(NfoMessage message)
                {
                    if(message.getGameType() == null || message.getGameType().equals(""))
                    {
                        return true;
                    }
                    return false;
                }
            };

    @Inject
    public USAR2004Bot(USAR2004AgentParameters parameters, IComponentBus eventBus, IAgentLogger logger, IWorldView worldView, IAct act, IUSAR2004BotController init) {
        super(parameters.getAgentId(), eventBus, logger, (WORLD_VIEW) worldView, (ACT) act);

        controller = init;

        init.initializeController(this);
        init.prepareBot(this);
        getWorldView().addEventListener(NfoMessage.class, firstNfoMessageListener);
    }
}
