package cz.cuni.amis.pogamut.usar2004.communication.translator.state;

import cz.cuni.amis.fsm.FSMInitialState;
import cz.cuni.amis.fsm.FSMState;
import cz.cuni.amis.fsm.IFSMState;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.usar2004.communication.translator.AbstractBotFSMState;
import cz.cuni.amis.pogamut.usar2004.communication.translator.USARTranslatorContext;


/**
 * This state is introduced because start/end messages of the list of item categories, mutators, navpoints and players.
 * Without this state we would have difficulties with switching between MutatorListState -> PlayerListState -> etc...<p>
 * As there is always: ... list ... END_MSG NEW_START_MSG ... list ... the problem lies withing END_MSG and NEW_START_MSG.
 * On END_MSG we will switch to this state and on NEW_START_MSG we will switch to the state that will handle appropriate
 * incoming list.
 */
@FSMState(
			map={

			}
		 )
@FSMInitialState
public class DefaultState extends AbstractBotFSMState<InfoMessage, USARTranslatorContext>{

	@Override
	public void init(USARTranslatorContext context) {
	}

	@Override
	public void restart(USARTranslatorContext context) {
	}

	@Override
	public void stateEntering(USARTranslatorContext context,
			IFSMState<InfoMessage, USARTranslatorContext> fromState,
			InfoMessage symbol) {
	}

	@Override
	public void stateLeaving(USARTranslatorContext context,
			IFSMState<InfoMessage, USARTranslatorContext> toState, InfoMessage symbol) {
	}

    @Override
    public void stateSymbol(USARTranslatorContext context, InfoMessage symbol) {

        context.getEventQueue().pushEvent((IWorldChangeEvent) symbol);
        
       // throw new UnsupportedOperationException("Not supported yet.");
    }

	/*@Override
	public void stateSymbol(USARTranslatorContext context, InfoMessage symbol) {
           // context.getEventQueue().pushEvent((IWorldChangeEvent) symbol);
		/*if (symbol instanceof GameInfo) {
			context.getEventQueue().pushEvent((GameInfo)symbol);
			return;
		}
	}*/

}
