package cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages;

import java.util.*;
import cz.cuni.amis.pogamut.base.communication.worldview.event.*;
import cz.cuni.amis.pogamut.base.communication.translator.event.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * Configuration message occurs after user has sent a command GetConf. Please
 * note that the robot Configuration message parameters depend on the type of
 * robot that you are driving. For example, a robot of type “GroundVehicle” will
 * not have the same Configuration message as a robot of type “AerialVehicle.” *
 * Corresponding GameBots message is CONF.
 *
 */
public class ConfigurationMessage extends GBEvent implements IWorldEvent, IWorldChangeEvent
{
    public ConfigurationMessage(String Type, double MaxFrontSteer, double MaxRearSteer, double Mass, String SteeringType)
    {
        this.Type = Type;
        this.Mass = Mass;
        this.MaxFrontSteer = MaxFrontSteer;
        this.MaxRearSteer = MaxRearSteer;
        this.SteeringType = SteeringType;
    }
    /**
     * Example how the message looks like - used during parser tests.
     */
    public static final String PROTOTYPE = "CONF {Type text} {Mass 0} {MaxFrontSteer 0} {MaxRearSteer 0} {SteeringType text}";
    protected String Type = null;

    /**
     * Type describes the vehicle type. It will be one of the following values:
     * "GroundVehicle”, “LeggedRobot”, “NauticVehicle”, or “AerialVehicle” of
     * "Camera" or some kind of sensor or effecter or "MisPkg".
     *
     * @return Returns type of the geometry message.
     */
    public String getType()
    {
        return Type;
    }
    //Ground Vehicle - Type, Name, SteeringType, Mass, MaxSpeed, MaxTorque, MaxFrontSteer, MaxRearSteer
    //Name value of ground, nautic, aerial...vehicles is present in the Map (pairs) Name/Value for sensor messages.
    protected String Name = null;

    /**
     * Name of the subject that this geometry message concerns.
     *
     * @return Returns the name of the Geometry item.
     */
    public String getName()
    {
        return Name;
    }
    protected String SteeringType = null;

    /**
     * Value should be one of the following: “AckermanSteered” or “SkidSteered”
     * or “OmniDrive”, as dictated by the steering type of the robot.
     *
     * @return Returns steering type of the robot.
     */
    public String getSteeringType()
    {
        return SteeringType;
    }
    protected double Mass = 0;

    /**
     * It is the robot's mass in kg.
     *
     * @return Returns mass of the robot.
     */
    public double getMass()
    {
        return Mass;
    }
    //these are represented by the lists down in mission package block
//        protected double MaxSpeed = 0;
//
//        public double getMaxSpeed() {
//            return MaxSpeed;
//        }
//        
//        protected double MaxTorque = 0;
//
//        public double getMaxTorque() {
//            return MaxTorque;
//        }
    protected double MaxFrontSteer = 0;

    /**
     * The maximum steering angle for robot’s front wheels, in radians. Please
     * note that this value will be 0 for skid steered vehicles.
     *
     * @return Returns maximum front steer.
     */
    public double getMaxFrontSteer()
    {
        return MaxFrontSteer;
    }
    protected double MaxRearSteer = 0;

    /**
     * The maximum steering angle for robot’s rear wheels, in radians. Please
     * note that this value will be 0 for skid steered vehicles.
     *
     * @return Returns maximum rear steer.
     */
    public double getMaxRearSteer()
    {
        return MaxRearSteer;
    }
    //Legged Robot - Type, Name, SteeringType, Mass
    //Nautic Vehicle - Type, Name, Dimensions, COG
    //Aerial Vehicle - Type, Name, Dimensions, COG
    //Sensor/effecter - Type, Name/Value..., Opcode..., MaxVal..., MinVal... 
    protected Map<String, String> Features = new HashMap<String, String>();

    /**
     * For a camera, sensor or effecter, a configuration message conatins a pair
     * ‘{Name Value}’ that describes the feature of this sensor type. Different
     * sensor types have different name value pairs. For detailed information,
     * please refer to section 10 of USARSim manual v3.1.3 about how to
     * configure the sensor.
     *
     * Example: CONF {Type Camera} {CameraDefFov 0.8727} {CameraMinFov 0.3491}
     * {CameraMaxFov 2.0943} {CameraFov 0.8726}
     *
     * @return Returns Map of features.
     */
    public Map<String, String> getFeatures()
    {
        return Features;
    }
    protected List<String> Names = new ArrayList<String>();

    /**
     * For an effector, the configuration message can contain multiple names.
     *
     * NOTE: An effecter can implement more than one opcode and the CONF message
     * returns the configuration information for all effecters on the robotic
     * platform. Therefore the segment with the name value pair indicates a new
     * effecter and the opcode name value pair indicates the opcode the effecter
     * specified in by name implements.
     *
     * @return Returns list of names.
     */
    public List<String> getNames()
    {
        return Names;
    }
    protected List<String> Opcodes = new ArrayList<String>();

    /**
     * For an effector, the configuration message can contain multiple OpCodes.
     * Opcode value is the name of the opcode that the effecter implements.
     * Refer to Section 8 of USARSim Manual v3.1.3 for a list of the opcodes.
     *
     * NOTE: An effecter can implement more than one opcode and the CONF message
     * returns the configuration information for all effecters on the robotic
     * platform. Therefore the segment with the name value pair indicates a new
     * effecter and the opcode name value pair indicates the opcode the effecter
     * specified in by name implements.
     *
     * @return Returns list of Operation Codes.
     */
    public List<String> getOpcodes()
    {
        return Opcodes;
    }
    protected List<Double> MaxVals = new ArrayList<Double>();

    /**
     * It is value that indicates the upper bound for the value that is accepted
     * by the effecter.
     *
     * @return Returns list of max values for effecters.
     */
    public List<Double> getMaxVals()
    {
        return MaxVals;
    }
    protected List<Double> MinVals = new ArrayList<Double>();

    /**
     * It is value that indicates the lower bound for the value that is accepted
     * by the effecter.
     *
     * @return Returns list of min values for effecters.
     */
    public List<Double> getMinVals()
    {
        return MinVals;
    }
    //Mission Package - Type, Name, Link..., JointType..., MaxSpeed..., MaxTorque..., MinRange..., MaxRange...
    //NOTE: For revolute joints, if the MinRange parameter is greater than the MaxRange 
    //parameter, the joint does not have any constraints.  
    protected List<Integer> Links = new ArrayList<Integer>();

    /**
     * Each value is the mission package’s link number(or index) that is
     * described further by JoinType, Max/Min Torque, Max/Min Speed and Max/Min
     * Range.
     *
     * @return Returns list of links.
     */
    public List<Integer> getLinks()
    {
        return Links;
    }
    protected List<String> JointTypes = new ArrayList<String>();

    /**
     * Each value can either be “Revolute” or “Prismatic”, as determined by the
     * type of joint being described.
     *
     * @return Returns list of joint types.
     */
    public List<String> getJointTypes()
    {
        return JointTypes;
    }
    protected List<Double> MaxSpeeds = new ArrayList<Double>();

    /**
     * Each value describes the joint’s maximum speed, in rad/s.
     *
     * @return Returns list of maximum speeds.
     */
    public List<Double> getMaxSpeeds()
    {
        return MaxSpeeds;
    }
    protected List<Double> MaxTorques = new ArrayList<Double>();

    /**
     * Each value describes the joint’s maximum torque.
     *
     * @return Returns list of maximum torques.
     */
    public List<Double> getMaxTorques()
    {
        return MaxTorques;
    }
    protected List<Double> MaxRanges = new ArrayList<Double>();

    /**
     * For a revolute joint, Each value is the maximum absolute angle that the
     * joint can rotate to. For a prismatic joint, Each value is the maximum
     * distance that the joint can move to.
     *
     * @return Returns list of maximum ranges.
     */
    public List<Double> getMaxRanges()
    {
        return MaxRanges;
    }
    protected List<Double> MinRanges = new ArrayList<Double>();

    /**
     * For a revolute joint, Each value is the minimum absolute angle that the
     * joint can rotate to. For a prismatic joint, Each value is the minimum
     * distance that the joint can move to.
     *
     * @return Returns list of minimal ranges.
     */
    public List<Double> getMinRanges()
    {
        return MinRanges;
    }

    /**
     * Cloning constructor.
     */
    public ConfigurationMessage(ConfigurationMessage original)
    {
        this.Type = original.Type;
        this.Mass = original.Mass;
        this.MaxFrontSteer = original.MaxFrontSteer;
        this.MaxRearSteer = original.MaxRearSteer;
        this.SteeringType = original.SteeringType;
        this.JointTypes.addAll(original.JointTypes);
        this.Links.addAll(original.Links);
        this.MaxRanges.addAll(original.MaxRanges);
        this.MaxSpeeds.addAll(original.MaxSpeeds);
        this.MaxTorques.addAll(original.MaxTorques);
        this.MaxVals.addAll(original.MaxVals);
        this.Features.putAll(original.Features);
        this.Names.addAll(original.Names);
        this.Opcodes.addAll(original.Opcodes);
        this.MinVals.addAll(original.MinVals);
        this.MinRanges.addAll(original.MinRanges);
        this.Name = original.Name;
    }

    /**
     * Used by Yylex to create empty message then to fill it's protected fields
     * (Yylex is in the same package).
     */
    public ConfigurationMessage()
    {
    }

    @Override
    public String toString()
    {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString() + " | "
                + "Type = "
                + String.valueOf(Type) + " | "
                + "MaxFrontSteer = "
                + String.valueOf(MaxFrontSteer) + " | "
                + "MaxRearSteer = "
                + String.valueOf(MaxRearSteer) + " | "
                + "Mass = "
                + String.valueOf(Mass) + " | ");

        if(SteeringType != null)
        {
            buf.append("SteeringType = ").append(String.valueOf(SteeringType)).append(" | ");
        }

        if(!JointTypes.isEmpty())
        {
            for(String i : JointTypes)
            {
                buf.append("JointType = ").append(i).append(" ");
            }
            buf.append(" | ");
        }



        if(!Links.isEmpty())
        {
            for(Integer i : Links)
            {
                buf.append("Link = ").append(i.toString()).append(" ");
            }
            buf.append(" | ");
        }


        if(!MaxRanges.isEmpty())
        {
            for(Double i : MaxRanges)
            {
                buf.append("MaxRange = ").append(i.toString()).append(" ");
            }
            buf.append(" | ");
        }


        if(!MaxSpeeds.isEmpty())
        {
            for(Double i : MaxSpeeds)
            {
                buf.append("MaxSpeed = ").append(i.toString()).append(" ");
            }
            buf.append(" | ");
        }


        if(!MaxTorques.isEmpty())
        {
            for(Double i : MaxTorques)
            {
                buf.append("MaxTorque = ").append(i.toString()).append(" ");
            }
            buf.append(" | ");
        }


        if(!MaxVals.isEmpty())
        {
            for(Double i : MaxVals)
            {
                buf.append("MaxVal = ").append(i.toString()).append(" ");
            }
            buf.append(" | ");
        }


        if(!Names.isEmpty())
        {
            for(String i : Names)
            {
                buf.append("Name = ").append(i.toString()).append(" ");
            }
            buf.append(" | ");
        }


        if(!Opcodes.isEmpty())
        {
            for(String i : Opcodes)
            {
                buf.append("Opcode = ").append(i.toString()).append(" ");
            }
            buf.append(" | ");
        }



        if(!MinVals.isEmpty())
        {
            for(Double i : MinVals)
            {
                buf.append("MinVal = ").append(i.toString()).append(" ");
            }
            buf.append(" | ");
        }


        if(!MinRanges.isEmpty())
        {
            for(Double i : MinRanges)
            {
                buf.append("MinRange = ").append(i.toString()).append(" ");
            }
            buf.append(" | ");
        }

        if(Name != null)
        {
            buf.append("Name = ").append(Name).append(" ");
            buf.append(" | ");
        }



        if(!Features.isEmpty())
        {
            Iterator it = Features.entrySet().iterator();
            while(it.hasNext())
            {
                Map.Entry en = (Map.Entry) it.next();
                buf.append(" ").append(en.getKey()).append(" ").append(en.getValue()).append(",");
            }
            buf.append(" | ");
        }

        return buf.toString();
    }

    /**
     * Gets all properties and values to create a HTML formated string;
     *
     * @return Returns all properties in HTML format
     */
    public String toHtmlString()
    {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString()
                + "<b>Type</b> : "
                + String.valueOf(Type)
                + " <br/> "
                + "<b>Mass</b> : "
                + String.valueOf(Mass)
                + " <br/> "
                + "<b>MaxFrontSteer</b> : "
                + String.valueOf(MaxFrontSteer)
                + " <br/> "
                + "<b>MaxRearSteer</b> : "
                + String.valueOf(MaxRearSteer)
                + " <br/> "
                + "<b>SteeringType</b> : "
                + String.valueOf(SteeringType)
                + " <br/> ");

        if(!JointTypes.isEmpty())
        {
            for(String i : JointTypes)
            {
                buf.append("<b>JointType</b> : ").append(i).append(" ");
            }
        }

        buf.append(" <br/> ");


        if(!Links.isEmpty())
        {
            for(Integer i : Links)
            {
                buf.append("<b>Link</b> : ").append(i.toString()).append(" ");
            }
        }

        buf.append(" <br/> ");

        if(!MaxRanges.isEmpty())
        {
            for(Double i : MaxRanges)
            {
                buf.append("<b>MaxRange</b> : ").append(i.toString()).append(" ");
            }
        }

        buf.append(" <br/> ");

        if(!MaxSpeeds.isEmpty())
        {
            for(Double i : MaxSpeeds)
            {
                buf.append("<b>MaxSpeed</b> : ").append(i.toString()).append(" ");
            }
        }

        buf.append(" <br/> ");

        if(!MaxTorques.isEmpty())
        {
            for(Double i : MaxTorques)
            {
                buf.append("<b>MaxTorque</b> : ").append(i.toString()).append(" ");
            }
        }

        buf.append(" <br/> ");

        if(!MaxVals.isEmpty())
        {
            for(Double i : MaxVals)
            {
                buf.append("<b>MaxVal</b> : ").append(i.toString()).append(" ");
            }
        }

        buf.append(" <br/> ");

        if(!Names.isEmpty())
        {
            for(String i : Names)
            {
                buf.append("<b>Name</b> : ").append(i.toString()).append(" ");
            }
        }

        buf.append(" <br/> ");

        if(!Opcodes.isEmpty())
        {
            for(String i : Opcodes)
            {
                buf.append("<b>Opcode</b> : ").append(i.toString()).append(" ");
            }
        }


        buf.append(" <br/> ");

        if(!MinVals.isEmpty())
        {
            for(Double i : MinVals)
            {
                buf.append("<b>MinVal</b> : ").append(i.toString()).append(" ");
            }
        }

        buf.append(" <br/> ");

        if(!MinRanges.isEmpty())
        {
            for(Double i : MinRanges)
            {
                buf.append("<b>MinRange</b> : ").append(i.toString()).append(" ");
            }
        }
        buf.append(" <br/> ");

        if(Name != null)
        {
            buf.append("<b>Name</b> : ").append(Name).append(" ");
        }

        buf.append(" <br/> ");


        if(!Features.isEmpty())
        {
            Iterator it = Features.entrySet().iterator();
            while(it.hasNext())
            {
                Map.Entry en = (Map.Entry) it.next();
                buf.append("<b>").append(en.getKey()).append("</b> : ").append(en.getValue()).append(",");
            }
        }

        buf.append(" <br/> ");
        return buf.toString();
    }
}
