package cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes;

/**
 * List of all Robot config Types. Each type can possibly represent more kinds
 * of config of same type. For each enum record, there exists relevant Class
 * which can be returned on demand.
 *
 * @author vejmanm
 */
public enum TraceColor
{
    RED("RED"),
    YELLOW("YELLOW"),
    GREEN("GREEN"),
    CYAN("CYAN"),
    WHITE("WHITE"),
    BLUE("BLUE"),
    PURPLE("PURPLE");
    private String color;

    /**
     *
     * @param color - String color
     */
    TraceColor(String color)
    {
        this.color = color;
    }

    /**
     * For each config type it checks if <B>type</B> matches one of
     * <B>kinds</B>. If so, it returns relevant ConfigType. Notice that this
     * method is static. If nothing matches, it returns SENSOR
     *
     * @param type String representation or kind of Config
     * @return Returns relevant ConfigType value to the String <B>type</B>
     */
    public static TraceColor getType(String type)
    {
        for(TraceColor colour : TraceColor.values())
        {
            if(colour.color.equalsIgnoreCase(type))
            {
                return colour;
            }
        }
        return RED;
    }

    /**
     * Note that this method is not static.
     *
     * @return Returns color relevant to Actual ConfigType
     */
    public String getName()
    {
        return this.color;
    }
}
