package cz.cuni.amis.pogamut.usar2004.agent.module.response;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.ResponseType;

/**
 * response message recieved after SET {Type Viewports} command
 *
 * @author vejmanm
 */
public class Viewport extends SuperResponse
{
    public static final ResponseType type = ResponseType.VIEWPORT;

    /**
     * Ctor. Response type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public Viewport()
    {
        super(type);
    }

    /**
     * Describes the current viewport configuration. This parameter will be
     * either “SingleView” or “QuadView”
     *
     * @return Returns configuration of current viewport.
     */
    public String getConfig()
    {
        return lastMessage.getConfig();
    }

    /**
     * Status of the viewport configuration after the SET command has been
     * issued. The status will be “OK” when the viewport configuration was
     * successfully changed. Otherwise, the status will be “Failed”.
     *
     * List of statuses is also used when setting cameras. Each value is then
     * the status for the camera’s field of view after the SET command has been
     * issued. The status will be “OK” when the camera’s field of view was
     * successfully changed. Otherwise, the status will be “Failed”.
     *
     * When responsing to SET command for sensor or effecter, single value
     * describing the status of the transaction will be present in the list.
     *
     * @return Returns first status.
     */
    public String getStatusOne()
    {
        if(getStatusSize() > 0)
        {
            return lastMessage.getStatuses().get(0);
        }
        return null;
    }

    /**
     * Status of the viewport configuration after the SET command has been
     * issued. The status will be “OK” when the viewport configuration was
     * successfully changed. Otherwise, the status will be “Failed”.
     *
     * List of statuses is also used when setting cameras. Each value is then
     * the status for the camera’s field of view after the SET command has been
     * issued. The status will be “OK” when the camera’s field of view was
     * successfully changed. Otherwise, the status will be “Failed”.
     *
     * When responsing to SET command for sensor or effecter, single value
     * describing the status of the transaction will be present in the list.
     *
     * @return Returns second status.
     */
    public String getStatusTwo()
    {
        if(getStatusSize() > 1)
        {
            return lastMessage.getStatuses().get(1);
        }
        return null;
    }

    /**
     * Status of the viewport configuration after the SET command has been
     * issued. The status will be “OK” when the viewport configuration was
     * successfully changed. Otherwise, the status will be “Failed”.
     *
     * List of statuses is also used when setting cameras. Each value is then
     * the status for the camera’s field of view after the SET command has been
     * issued. The status will be “OK” when the camera’s field of view was
     * successfully changed. Otherwise, the status will be “Failed”.
     *
     * When responsing to SET command for sensor or effecter, single value
     * describing the status of the transaction will be present in the list.
     *
     * @return Returns third status.
     */
    public String getStatusThree()
    {
        if(getStatusSize() > 2)
        {
            return lastMessage.getStatuses().get(2);
        }
        return null;
    }

    /**
     * Status of the viewport configuration after the SET command has been
     * issued. The status will be “OK” when the viewport configuration was
     * successfully changed. Otherwise, the status will be “Failed”.
     *
     * List of statuses is also used when setting cameras. Each value is then
     * the status for the camera’s field of view after the SET command has been
     * issued. The status will be “OK” when the camera’s field of view was
     * successfully changed. Otherwise, the status will be “Failed”.
     *
     * When responsing to SET command for sensor or effecter, single value
     * describing the status of the transaction will be present in the list.
     *
     * @return Returns fourth status.
     */
    public String getStatusFour()
    {
        if(getStatusSize() > 3)
        {
            return lastMessage.getStatuses().get(3);
        }
        return null;
    }

    /**
     * Each value is the name of the camera currently attached to viewportN,
     * where N is 1..4. If viewportN has been disabled, this parameter will be
     * “Disabled”. If viewportN has been attached to a non- existent camera,
     * this parameter will be “None”.
     *
     * @return Returns first viewport.
     */
    public String getViewportOne()
    {
        if(getViewportSize() > 0)
        {
            return lastMessage.getViewports().get(0);
        }
        return null;
    }

    /**
     * Each value is the name of the camera currently attached to viewportN,
     * where N is 1..4. If viewportN has been disabled, this parameter will be
     * “Disabled”. If viewportN has been attached to a non- existent camera,
     * this parameter will be “None”.
     *
     * @return Returns second viewport.
     */
    public String getViewportTwo()
    {
        if(getViewportSize() > 1)
        {
            return lastMessage.getViewports().get(1);
        }
        return null;
    }

    /**
     * Each value is the name of the camera currently attached to viewportN,
     * where N is 1..4. If viewportN has been disabled, this parameter will be
     * “Disabled”. If viewportN has been attached to a non- existent camera,
     * this parameter will be “None”.
     *
     * @return Returns third viewport.
     */
    public String getViewportThree()
    {
        if(getViewportSize() > 2)
        {
            return lastMessage.getViewports().get(2);
        }
        return null;
    }

    /**
     * Each value is the name of the camera currently attached to viewportN,
     * where N is 1..4. If viewportN has been disabled, this parameter will be
     * “Disabled”. If viewportN has been attached to a non- existent camera,
     * this parameter will be “None”.
     *
     * @return Returns fourth viewport.
     */
    public String getViewportFour()
    {
        if(getViewportSize() > 3)
        {
            return lastMessage.getViewports().get(3);
        }
        return null;
    }

    /**
     * Returns the viewport data length.
     *
     * @return Returns the viewport data length.
     */
    private int getViewportSize()
    {
        return lastMessage.getViewports().size();
    }

    /**
     * Returns the viewport status length.
     *
     * @return Returns the viewport status length.
     */
    private int getStatusSize()
    {
        return lastMessage.getStatuses().size();
    }
}
