package cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages;

import java.util.logging.Level;
import java.util.logging.Logger;
import cz.cuni.amis.pogamut.base.communication.worldview.event.*;
import cz.cuni.amis.pogamut.base.communication.translator.event.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.*;
import java.util.List;

/**
 *
 * A Mission Package state message reports the mission package links current
 * properties. Every mission package state includes a Name segment and several
 * link segments.
 *
 * Corresponding GameBots message is MISSTA.
 *
 */
public class MissionPackageMessage extends GBEvent implements IWorldEvent, IWorldChangeEvent
{
    /**
     * Creates new instance of command MissionPackageMessage.
     *
     * @param Time Timestamp form the UT since server start in seconds.
     * @param Name Name of the mission package
     * @param Link This parameter gives the link number that will be described
     * by the next two parameters (Value and Torque). Please note that you will
     * have as many as these parameters as you have links.
     *
     * @param Value This parameter has two possible meanings. If the link being
     * described is a prismatic joint, double gives the distance (in meters)
     * from the original position of the link. If the link being described is a
     * revolute joint, it gives a sector(probably).
     *
     * @param Torque The Torque parameter gives the current torque of the link
     * being described.
     */
    public MissionPackageMessage(double Time, String Name, int Link, double Value, double Torque)
    {
        this.Time = Time;
        this.Name = Name;
        this.Links.add(Link, Value, Torque);
    }

    public MissionPackageMessage(double Time, String Name, LinkState LS)
    {
        this.Time = Time;
        this.Name = Name;
        this.Links.add(LS);
    }
    /**
     * Example how the message looks like - used during parser tests.
     */
    public static final String PROTOTYPE = "MISSTA {Time 0} {Name text}";//{Value 0} {Torque 0}";
    /////// Properties BEGIN
    protected double Time = 0;

    /**
     * Timestamp form the UT since server start in seconds.
     *
     * @return Returns seconds elapsed from the start of the server.
     */
    public double getTime()
    {
        return Time;
    }
    protected String Name = null;

    /**
     * Name of the mission package
     *
     * @return; Returns the name of the mission package
     */
    public String getName()
    {
        return Name;
    }
    //LinkStateSet brings data of all links to one structure
    protected LinkStateSet Links = new LinkStateSet();

    /**
     * This parameter gives the link number that will be described by the next
     * two parameters (Value and Torque). Please note that you will have as many
     * as these parameters as you have links.
     *
     * VALUE parameter has two possible meanings. If the link being described is
     * a prismatic joint, double gives the distance (in meters) from the
     * original position of the link. If the link being described is a revolute
     * joint, it gives a sector(probably).
     *
     * The TORQUE parameter gives the current torque of the link being
     * described. * All of the above are collected into one data structure below
     * this text.
     *
     * @return Returns collection of Link States.
     */
    public List<LinkState> getLinkStateSet()
    {
        return Links.GetLinkStateList();
    }

    /**
     * Cloning constructor.
     */
    public MissionPackageMessage(MissionPackageMessage original)
    {
        this.Time = original.Time;
        this.Name = original.Name;
        this.Links = original.Links;
    }

    /**
     * Used by Yylex to create empty message then to fill it's protected fields
     * (Yylex is in the same package).
     */
    public MissionPackageMessage()
    {
    }

    @Override
    public String toString()
    {
        StringBuilder buf = new StringBuilder();

        buf.append(super.toString()).append(" | " + "Time = ").append(String.valueOf(Time)).append(" | " + "Name = ").append(String.valueOf(Name)).append(" | ");
        if(!Links.isEmpty())
        {

            try
            {
                for(LinkState linkState : Links.GetLinkStateList())
                {
                    buf.append("Link = " + String.valueOf(linkState.getLink()) + " | "
                            + "Value = "
                            + String.valueOf(linkState.getValue()) + " | "
                            + "Torque = "
                            + String.valueOf(linkState.getTorque()) + " | ");
                }
            }
            catch(Exception ex)
            {
                Logger.getLogger(MissionPackageMessage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        return buf.toString();

    }

    /**
     * Gets all properties and values to create a HTML formated string;
     *
     * @return Returns all properties in HTML format
     */
    public String toHtmlString()
    {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString()).append("<b>Time</b> : ").append(String.valueOf(Time)).append(" <br/> " + "<b>Name</b> : ").append(String.valueOf(Name)).append(" <br/> ");
        if(!Links.isEmpty())
        {
            try
            {
                for(LinkState linkState : Links.GetLinkStateList())
                {
                    buf.append("<b>Link</b> : "
                            + String.valueOf(linkState.getLink())
                            + " <br/> "
                            + "<b>Value</b> : "
                            + String.valueOf(linkState.getValue())
                            + " <br/> "
                            + "<b>Torque</b> : "
                            + String.valueOf(linkState.getTorque())
                            + " <br/> ");

                }
            }
            catch(Exception ex)
            {
                Logger.getLogger(MissionPackageMessage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return buf.toString();

    }
}
