package cz.cuni.amis.pogamut.udk.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;

/**
 * Finds the shortest through internal A* algorithm in the UDK. The path info is send through GB2004 messages.
 * <p><p>
 * Returns {@link UDKAStarPathFuture} that contains the logic for obtaining the path from UDK (note that it takes
 * some time then UDK sends you a path).
 * <p><p>
 * <b>IMPORTANT:</b> Due to restrictions of the UnrealScript path planner this implementation returns only paths of maximal length 16.
 * Therefore returned path may end on the half way trough. Therefore, whenever the {@link IPathExecutor} reports that
 * the bot has reached its target, you should compare bot's current position and the {@link UDKAStarPathFuture#getPathTo()}.
 * 
 * @author Ik
 * @author Jimmy
 */
public class UDKAStarPathPlanner implements IPathPlanner<ILocated> {

	private UDKBot bot;

	public UDKAStarPathPlanner(UDKBot bot) {
		this.bot = bot;
	}
	
	@Override
	public IPathFuture<ILocated> computePath(ILocated from, ILocated to) {
		return new UDKAStarPathFuture(bot, from, to);
	}

	@Override
	public double getDistance(ILocated from, ILocated to) {
		throw new RuntimeException("Unsupported operation!");
	}
	

}
