/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.communication.translator.itemdescriptor;

import cz.cuni.amis.pogamut.base.communication.exception.CommunicationException;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.udk.communication.messages.ItemType;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.ItemCategory;
import cz.cuni.amis.pogamut.udk.communication.translator.itemdescriptor.AmmoDescriptorFactory;
import cz.cuni.amis.pogamut.udk.communication.translator.itemdescriptor.ArmorDescriptorFactory;
import cz.cuni.amis.pogamut.udk.communication.translator.itemdescriptor.GeneralDescriptor;
import cz.cuni.amis.pogamut.udk.communication.translator.itemdescriptor.HealthDescriptorFactory;
import cz.cuni.amis.pogamut.udk.communication.translator.itemdescriptor.ItemDescriptor;
import cz.cuni.amis.pogamut.udk.communication.translator.itemdescriptor.ItemTyped;
import cz.cuni.amis.pogamut.udk.communication.translator.itemdescriptor.OtherDescriptorFactory;
import cz.cuni.amis.pogamut.udk.communication.translator.itemdescriptor.WeaponDescriptorFactory;
import java.util.HashMap;

@AgentScoped
public class ItemTranslator {
    private HashMap<ItemType, ItemDescriptor> descriptors = new HashMap();
    private HashMap<ItemType, GeneralDescriptor> userDescriptors = new HashMap();

    public ItemType[] getItemTypes() {
        return this.descriptors.values().toArray(new ItemType[0]);
    }

    public ItemDescriptor getDescriptor(ItemTyped msg) {
        return this.getDescriptor(msg.getType());
    }

    public ItemDescriptor getDescriptor(ItemType type) {
        if (this.userDescriptors.containsKey(type)) {
            return this.userDescriptors.get(type);
        }
        return this.descriptors.get(type);
    }

    public ItemDescriptor getDefaultDescriptor(ItemType type) {
        return this.descriptors.get(type);
    }

    public void addCustomUserDescriptor(GeneralDescriptor userDescriptor) {
        this.userDescriptors.put(userDescriptor.getPickupType(), userDescriptor);
    }

    public ItemDescriptor createDescriptor(ItemCategory message) {
        ItemDescriptor result = null;
        switch (message.getType().getCategory()) {
            case AMMO: {
                result = AmmoDescriptorFactory.getInstance().getNewDescriptor(message);
                this.descriptors.put(message.getType(), result);
                break;
            }
            case ARMOR: {
                result = ArmorDescriptorFactory.getInstance().getNewDescriptor(message);
                this.descriptors.put(message.getType(), result);
                break;
            }
            case OTHER: {
                result = OtherDescriptorFactory.getInstance().getNewDescriptor(message);
                this.descriptors.put(message.getType(), result);
                break;
            }
            case HEALTH: {
                result = HealthDescriptorFactory.getInstance().getNewDescriptor(message);
                this.descriptors.put(message.getType(), result);
                break;
            }
            case WEAPON: {
                result = WeaponDescriptorFactory.getInstance().getNewDescriptor(message);
                this.descriptors.put(message.getType(), result);
                break;
            }
            default: {
                throw new CommunicationException("should not reach here - new ItemType.Category has been added and not handled inside the ItemTranslator, item type = " + message.getType(), (Object)this);
            }
        }
        return result;
    }
}

