package cz.cuni.amis.pogamut.udk.communication.translator.server.state;

import cz.cuni.amis.fsm.FSMState;
import cz.cuni.amis.fsm.FSMTransition;
import cz.cuni.amis.fsm.IFSMState;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Mutator;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Vehicle;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.VehicleListEnd;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.VehicleListStart;
import cz.cuni.amis.pogamut.udk.communication.translator.TranslatorContext;
import cz.cuni.amis.pogamut.udk.communication.translator.bot.support.BotListState;
import cz.cuni.amis.pogamut.udk.communication.translator.server.support.ServerListState;
import cz.cuni.amis.pogamut.udk.communication.translator.shared.events.MutatorListObtained;
import cz.cuni.amis.pogamut.udk.communication.translator.shared.events.PlayerListObtained;
import cz.cuni.amis.pogamut.udk.communication.translator.shared.events.VehicleListObtained;

/**
 * Takes care of the vehicle list. It stores them inside a List object and when END message comes it sends
 * them to the world view via VehicleListObtained event.
 * <p><p>
 * Last state of the handshake - we switch from this state to the ConfigureMessageExpectedState. 
 * 
 * @author Radek 'Black_Hand' Pibil
 */
@FSMState(map={@FSMTransition(
					state=ServerRunningState.class, 
					symbol={VehicleListEnd.class},
					transition={})}
)
public class VehicleListState extends ServerListState<Vehicle, TranslatorContext> {

	public VehicleListState() {
		super(VehicleListStart.class, Vehicle.class, VehicleListEnd.class);
	}
	
	@Override
	public void stateLeaving(TranslatorContext context,
			IFSMState<InfoMessage, TranslatorContext> toState, InfoMessage symbol) {
		super.stateLeaving(context, toState, symbol);
		context.getEventQueue().pushEvent(new VehicleListObtained(getList()));
		newList();
	}
	
	@Override
	public void innerStateSymbol(TranslatorContext context, InfoMessage symbol) {
		super.innerStateSymbol(context, symbol);
		if (symbol instanceof Vehicle) {
			context.getEventQueue().pushEvent((Vehicle)symbol);
		}
	}
}
