/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.utils;

import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.OsProcess;
import com.jezhumble.javasysmon.ProcessVisitor;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.state.WaitForAgentStateChange;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStopException;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.ChangeMap;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.Console;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.MapChange;
import cz.cuni.amis.pogamut.udk.factory.direct.remoteagent.UDKServerFactory;
import cz.cuni.amis.pogamut.udk.server.IUDKServer;
import cz.cuni.amis.pogamut.udk.server.exception.UCCStartException;
import cz.cuni.amis.pogamut.udk.utils.PogamutUDKProperty;
import cz.cuni.amis.pogamut.udk.utils.UDKServerRunner;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.Flag;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UCCWrapper {
    public static final long DEFAULT_START_TIMEOUT = 120000L;
    private static final Object spawnProcessMutex = new Object();
    public static final int CHANGE_MAP_COMMAND_MAX_REPEATS = 5;
    public static final long DEFAULT_UDK_EXE_SPAWN_TIMEOUT_WINDOWS = 10000L;
    public static final long DEFAULT_UDK_EXE_SPAWN_TIMEOUT_UNIX = 30000L;
    public static final int CHANGE_MAP_CONFIRMATION_TIMEOUT = 500;
    protected LogCategory uccLog;
    protected static int fileCounter = 0;
    Process uccProcess = null;
    protected int gbPort = -1;
    protected int controlPort = -1;
    protected int observerPort = -1;
    protected IUDKServer utServer = null;
    protected static final int basePort = 39782;
    protected static Integer nextUccWrapperUID = 0;
    protected int uccWrapperUID = 0;
    protected String unrealHome = null;
    protected UCCWrapperConf configuration = null;
    protected long startingTimeout = 120000L;
    protected int uccPid = -1;
    protected UDKServerFactory serverFactory;
    protected boolean aggressiveKilling = false;
    private long udkExeSpawnTimeoutWindows = 10000L;
    private long udkExeSpawnTimeoutUnix = 30000L;
    ScannerSink scanner;
    Thread shutDownHook = new Thread("UCC wrapper finalizer"){

        @Override
        public void run() {
            UCCWrapper.this.stopNoWaiting();
        }
    };
    public static long stamp = System.currentTimeMillis();
    protected boolean stopped = false;

    public synchronized void start() throws UCCStartException {
        if (this.uccProcess != null) {
            throw new IllegalStateException("Wrapper already started");
        }
        this.initUCCWrapper();
        this.uccLog.info("Adding shutdown hook");
        Runtime.getRuntime().addShutdownHook(this.shutDownHook);
    }

    protected String getMapNameWithOptions() {
        String portsSetting;
        String id = System.currentTimeMillis() + "a" + fileCounter++;
        String fileWithPorts = "GBports" + id;
        if (this.configuration.botServerPort != null || this.configuration.controlServerPort != null) {
            portsSetting = "";
            if (this.configuration.controlServerPort != null) {
                portsSetting = portsSetting + "?ControlServerPort=" + this.configuration.controlServerPort;
            }
            if (this.configuration.botServerPort != null) {
                portsSetting = portsSetting + "?BotServerPort=" + this.configuration.botServerPort;
            }
        } else {
            portsSetting = this.configuration.startOnUnusedPort != false ? "?PortsLog=" + fileWithPorts + "?bRandomPorts=true" : "";
        }
        String gameOptions = this.configuration.mapName + "?game=" + this.configuration.gameBotsPack + "." + this.configuration.gameType + portsSetting + this.configuration.options;
        return gameOptions;
    }

    private Set<Integer> getNewUDKProcesses(JavaSysMon monitor, Set<Integer> oldUDKProcesses) {
        UDKChildProcessVisitor visitor = new UDKChildProcessVisitor();
        if (UCCWrapper.isWindows()) {
            monitor.visitProcessTree(monitor.currentPid(), (ProcessVisitor)visitor);
        } else {
            for (OsProcess child : monitor.processTree().children()) {
                monitor.visitProcessTree(child.processInfo().getPid(), (ProcessVisitor)visitor);
            }
        }
        Set<Integer> newProcesses = visitor.getUdkPids();
        newProcesses.removeAll(oldUDKProcesses);
        return newProcesses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Process spawnUDK(ProcessBuilder procBuilder) throws IOException {
        Object object = spawnProcessMutex;
        synchronized (object) {
            Set<Integer> newProcesses;
            long udkExeSpawnTimeout;
            JavaSysMon monitor = new JavaSysMon();
            UDKChildProcessVisitor beforeVisitor = new UDKChildProcessVisitor();
            if (UCCWrapper.isWindows()) {
                monitor.visitProcessTree(monitor.currentPid(), (ProcessVisitor)beforeVisitor);
                udkExeSpawnTimeout = this.udkExeSpawnTimeoutWindows;
            } else {
                for (OsProcess child : monitor.processTree().children()) {
                    monitor.visitProcessTree(child.processInfo().getPid(), (ProcessVisitor)beforeVisitor);
                }
                udkExeSpawnTimeout = this.udkExeSpawnTimeoutUnix;
            }
            Set<Integer> alreadySpawnedProcesses = beforeVisitor.getUdkPids();
            Process proc = procBuilder.start();
            long startTime = System.currentTimeMillis();
            while ((newProcesses = this.getNewUDKProcesses(monitor, alreadySpawnedProcesses)).isEmpty() && System.currentTimeMillis() - startTime < udkExeSpawnTimeout) {
            }
            if (newProcesses.isEmpty()) {
                this.uccLog.severe("There is no new UDK PID.");
            } else if (newProcesses.size() > 1) {
                this.uccLog.severe("Multiple new candidate UDK PIDs");
            } else {
                this.uccPid = newProcesses.iterator().next();
            }
            return proc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killUDKByPID() {
        if (this.uccPid < 0) {
            this.uccLog.severe("Cannot kill UCC by PID. PID not set.");
            return;
        }
        Object object = spawnProcessMutex;
        synchronized (object) {
            JavaSysMon monitor = new JavaSysMon();
            monitor.killProcessTree(this.uccPid, false);
            this.uccPid = -1;
        }
    }

    public static void killAllUCCs(LogCategory uccLog) {
        if (!UCCWrapper.isWindows()) {
            String[] command1 = new String[]{"killall", "UDK.com"};
            String[] command2 = new String[]{"killall", "UDK.exe"};
            try {
                Runtime.getRuntime().exec(command1);
                Runtime.getRuntime().exec(command2);
            }
            catch (IOException ex) {
                uccLog.log(Level.SEVERE, "Could not kill the UDK process: " + ex, (Throwable)ex);
            }
        } else {
            String[] command = new String[]{"taskkill", "/F", "/IM", "UDK.*"};
            try {
                Runtime.getRuntime().exec(command);
            }
            catch (IOException ex) {
                uccLog.log(Level.SEVERE, "Could not kill the UDK with taskkill: " + ex, (Throwable)ex);
            }
        }
    }

    public Logger getLogger() {
        return this.uccLog;
    }

    public synchronized IUDKServer getUTServer() {
        this.stopCheck();
        if (this.utServer == null) {
            UDKServerRunner serverRunner = new UDKServerRunner(this.serverFactory, "NBUTServer", this.getHost(), this.controlPort);
            this.utServer = serverRunner.startAgent();
        }
        return this.utServer;
    }

    public synchronized void restartServer() {
        this.stopCheck();
        this.utServer = null;
    }

    protected String getUnrealHome() {
        if (this.unrealHome == null) {
            return Pogamut.getPlatform().getProperty(PogamutUDKProperty.POGAMUT_UNREAL_HOME.getKey());
        }
        return this.unrealHome;
    }

    public UCCWrapper(UCCWrapperConf configuration) {
        this(configuration, new UDKServerFactory());
    }

    public UCCWrapper(UCCWrapperConf configuration, UDKServerFactory factory) {
        this(configuration, factory, true);
    }

    public UCCWrapper(UCCWrapperConf configuration, boolean startImmediately) {
        this(configuration, new UDKServerFactory(), startImmediately);
    }

    public UCCWrapper(UCCWrapperConf configuration, UDKServerFactory serverFactory, boolean startImmediately) throws UCCStartException {
        this.serverFactory = serverFactory;
        this.uccLog = new LogCategory("Wrapper");
        this.uccLog.addHandler((ILogPublisher)new LogPublisher.ConsolePublisher((IAgentId)new AgentId("UCC")));
        configuration.applyDefaults(UCCWrapperConf.DEFAULTS);
        if (configuration.log != null) {
            this.uccLog.setParent(configuration.log);
        }
        this.configuration = configuration;
        Integer n = nextUccWrapperUID;
        Integer n2 = nextUccWrapperUID = Integer.valueOf(nextUccWrapperUID + 1);
        this.uccWrapperUID = n;
        if (startImmediately) {
            this.start();
        }
    }

    public UCCWrapperConf getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(UCCWrapperConf configuration) {
        this.configuration = configuration;
    }

    public UDKServerFactory getServerFactory() {
        return this.serverFactory;
    }

    public void setServerFactory(UDKServerFactory serverFactory) {
        this.serverFactory = serverFactory;
    }

    public long getStartingTimeout() {
        return this.startingTimeout;
    }

    public void setStartingTimeout(long startingTimeout) {
        this.startingTimeout = startingTimeout;
    }

    public long getUdkExeSpawnTimeoutUnix() {
        return this.udkExeSpawnTimeoutUnix;
    }

    public void setUdkExeSpawnTimeoutUnix(long udkExeSpawnTimeoutUnix) {
        this.udkExeSpawnTimeoutUnix = udkExeSpawnTimeoutUnix;
    }

    public long getUdkExeSpawnTimeoutWindows() {
        return this.udkExeSpawnTimeoutWindows;
    }

    public void setUdkExeSpawnTimeoutWindows(long udkExeSpawnTimeoutWindows) {
        this.udkExeSpawnTimeoutWindows = udkExeSpawnTimeoutWindows;
    }

    public boolean isAggressiveKilling() {
        return this.aggressiveKilling;
    }

    public void setAggressiveKilling(boolean aggressiveKilling) {
        this.aggressiveKilling = aggressiveKilling;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    private void cleanupAfterException() {
        if (this.uccProcess != null) {
            this.uccProcess.destroy();
        }
        if (this.uccPid >= 0) {
            this.killUDKByPID();
        }
    }

    protected void initUCCWrapper() throws UCCStartException {
        try {
            String udkHomePath = this.getUnrealHome();
            String binariesPath = udkHomePath + File.separator + "Binaries";
            String uccFile = "Win32" + File.separator + "UDK.com";
            String uccFileAbsolute = binariesPath + File.separator + uccFile;
            ArrayList<String> command = new ArrayList<String>();
            if (UCCWrapper.isWindows()) {
                command.add(uccFileAbsolute);
            } else {
                if (this.configuration.wineprefix != null && !this.configuration.wineprefix.isEmpty()) {
                    command.add("WINEPREFIX=" + this.configuration.wineprefix);
                }
                command.add(Pogamut.getPlatform().getProperty("WINE", "wine"));
                command.add(uccFileAbsolute);
            }
            command.add("server");
            command.add(this.getMapNameWithOptions());
            if (this.configuration.otherCommandLineParameters != null) {
                command.add(this.configuration.otherCommandLineParameters);
            }
            if (!UCCWrapper.isWindows()) {
                command.add("-nohomedir");
            }
            ProcessBuilder procBuilder = new ProcessBuilder(command);
            procBuilder.directory(new File(binariesPath));
            this.uccProcess = this.spawnUDK(procBuilder);
            this.uccLog.info("Spawned UDK process. Pid: " + this.uccPid);
            this.scanner = new ScannerSink(this.uccProcess.getInputStream());
            this.scanner.start();
            new StreamSink(this.uccProcess.getErrorStream()).start();
            this.scanner.serverStartedLatch.await();
            if (this.scanner.exception != null) {
                this.cleanupAfterException();
                throw new UCCStartException("Scanner exception", (Object)this.scanner.exception);
            }
            this.controlPort = this.scanner.controlPort;
            this.gbPort = this.scanner.botsPort;
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            this.cleanupAfterException();
            throw new UCCStartException("Interrupted.", ex);
        }
        catch (IOException ex) {
            this.cleanupAfterException();
            throw new UCCStartException("IO Exception.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeMap(String mapName, boolean notifyGame, long timeout) {
        block15: {
            this.uccLog.info("Changing map to: " + mapName);
            this.configuration.setMapName(mapName);
            if (((IAgentState)this.getUTServer().getState().getFlag()).isNotState(new Class[]{IAgentStateUp.class})) {
                this.restartServer();
                new WaitForAgentStateChange((Flag)this.getUTServer().getState(), IAgentStateUp.class).await(2L, TimeUnit.SECONDS);
            }
            CountDownLatch gameStartLatch = this.awaitGameStart();
            final CountDownLatch notifiedMapChangeLatch = new CountDownLatch(1);
            final String mapNameWithOptions = this.getMapNameWithOptions();
            IWorldEventListener<MapChange> mapChangeListener = new IWorldEventListener<MapChange>(){

                public void notify(MapChange event) {
                    if (event.getMapName().equals(mapNameWithOptions)) {
                        notifiedMapChangeLatch.countDown();
                    } else {
                        UCCWrapper.this.uccLog.severe("Notified of unexpected map change. Contiuning waiting. Notified for map:" + event.getMapName());
                    }
                }
            };
            this.getUTServer().getWorldView().addEventListener(MapChange.class, (IWorldEventListener)mapChangeListener);
            boolean mapChangeConfirmed = false;
            for (int i = 0; i < 5; ++i) {
                if (gameStartLatch.getCount() <= 0L) {
                    mapChangeConfirmed = true;
                    this.uccLog.info("New match started while waiting for ChangeMap confirmation. Let's trust it is the correct game.");
                    break;
                }
                if (((IAgentState)this.getUTServer().getState().getFlag()).isNotState(new Class[]{IAgentStateUp.class})) break;
                this.getUTServer().getAct().act((CommandMessage)new ChangeMap(mapNameWithOptions, notifyGame));
                try {
                    if (!notifiedMapChangeLatch.await(500L, TimeUnit.MILLISECONDS)) continue;
                    this.uccLog.info("ChangeMap confirmed from GB server");
                    try {
                        this.getUTServer().stop();
                    }
                    catch (ComponentCantStopException ex) {
                        this.uccLog.severe("Server could not stop: " + ex.getMessage());
                    }
                    mapChangeConfirmed = true;
                    break;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (!mapChangeConfirmed) {
                this.uccLog.severe("ChangeMap command was not confirmed. Trying to wait for map change anyway.");
            }
            try {
                try {
                    if (gameStartLatch.await(timeout, TimeUnit.MILLISECONDS)) {
                        if (this.scanner.exception != null) {
                            throw this.scanner.exception;
                        }
                        this.uccLog.info("Map changed.");
                        this.restartServer();
                        break block15;
                    }
                    this.uccLog.severe("Map change timed out.");
                    throw new PogamutException("Map change timed out.", (Object)this);
                }
                catch (InterruptedException ex) {
                    this.uccLog.severe("Waiting for map change interrupted.");
                    throw new PogamutInterruptedException("Waiting for map change interrupted.", (Throwable)ex, (Object)this);
                }
            }
            finally {
                gameStartLatch.countDown();
            }
        }
    }

    public CountDownLatch awaitGameStart() {
        return this.scanner.awaitGameStart();
    }

    public Process getProcess() {
        return this.uccProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stopNoWaiting() {
        if (this.stopped) {
            this.getLogger().info("UCCWrapper already stopped, ignoring call to stopNoWaiting()");
            return;
        }
        try {
            if (((IAgentState)this.getUTServer().getState().getFlag()).isNotState(new Class[]{IAgentStateUp.class})) {
                this.getLogger().info("Server component down, creating new to send EXIT command");
                this.utServer = null;
            }
            this.getLogger().info("Sending EXIT command");
            this.getUTServer().getAct().act((CommandMessage)new Console("EXIT"));
            WaitForAgentStateChange waitForServerDeath = new WaitForAgentStateChange((Flag)this.getUTServer().getState(), IAgentStateDown.class);
            try {
                waitForServerDeath.await(3L, TimeUnit.SECONDS);
            }
            catch (PogamutInterruptedException ex) {
                this.uccLog.log(Level.SEVERE, "Waiting for server death interrupted.", (Throwable)ex);
            }
            if (!((IAgentState)this.getUTServer().getState().getFlag()).isState(new Class[]{IAgentStateDown.class})) {
                this.getUTServer().kill();
                this.uccLog.severe("Server did not die in response to EXIT command. Trying to kill by pid.");
                this.killUDKByPID();
            } else if (this.isAggressiveKilling()) {
                this.uccLog.info("Aggressive killing set to true. Trying to kill by pid.");
                this.killUDKByPID();
            }
            this.utServer = null;
            if (this.uccProcess != null) {
                this.uccProcess.destroy();
            }
        }
        catch (Exception ex) {
            this.uccLog.severe("Exception killing UCCWrapper :" + ex.getMessage());
            this.uccLog.severe(ExceptionToString.process((Throwable)ex));
            if (this.isAggressiveKilling()) {
                this.uccLog.info("Aggressive killing set to true. Trying to kill by pid.");
                this.killUDKByPID();
            }
        }
        finally {
            this.uccProcess = null;
            this.stopped = true;
        }
    }

    public synchronized void stop() {
        if (this.uccProcess != null) {
            this.stopNoWaiting();
            this.getLogger().info("Removing shutdown hook");
            Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getBotPort() {
        this.stopCheck();
        return this.gbPort;
    }

    @Deprecated
    public int getObserverPort() {
        this.stopCheck();
        return this.observerPort;
    }

    public int getControlPort() {
        this.stopCheck();
        return this.controlPort;
    }

    protected void stopCheck() {
        if (this.stopped) {
            throw new PogamutException("UCC already stopped.", (Object)this);
        }
    }

    public String getHost() {
        return "localhost";
    }

    public SocketConnectionAddress getBotAddress() {
        return new SocketConnectionAddress(this.getHost(), this.getBotPort());
    }

    public SocketConnectionAddress getServerAddress() {
        return new SocketConnectionAddress(this.getHost(), this.getControlPort());
    }

    @Deprecated
    public SocketConnectionAddress getObserverAddress() {
        return new SocketConnectionAddress(this.getHost(), this.getObserverPort());
    }

    public class ScannerSink
    extends StreamSink {
        public UCCStartException exception;
        public CountDownLatch serverStartedLatch;
        public CountDownLatch mapChangedLatch;
        public int controlPort;
        public int botsPort;
        Timer timer;
        TimerTask task;
        private final String defaultPatternStart = "";
        private final Pattern portPattern;
        private final Pattern commandletNotFoundPattern;
        private final Pattern mapNotFoundPattern;
        private final Pattern matchStartedPattern;

        public ScannerSink(InputStream is) {
            super(is);
            this.exception = null;
            this.serverStartedLatch = new CountDownLatch(1);
            this.mapChangedLatch = null;
            this.controlPort = -1;
            this.botsPort = -1;
            this.timer = new Timer("UDK start timeout");
            this.task = null;
            this.defaultPatternStart = "";
            this.portPattern = Pattern.compile("BotServerPort:(\\d*) ControlServerPort:(\\d*)");
            this.commandletNotFoundPattern = Pattern.compile("Commandlet server not found");
            this.mapNotFoundPattern = Pattern.compile("No maplist entries found matching the current command line.*");
            this.matchStartedPattern = Pattern.compile("START MATCH");
            this.task = new TimerTask(){

                @Override
                public void run() {
                    ScannerSink.this.exception = new UCCStartException("Starting timed out. Ports weren't bound in the required time (" + UCCWrapper.this.startingTimeout + " ms).", this);
                    ScannerSink.this.timer.cancel();
                    ScannerSink.this.serverStartedLatch.countDown();
                }
            };
            this.timer.schedule(this.task, UCCWrapper.this.startingTimeout);
        }

        public CountDownLatch awaitGameStart() {
            if (this.serverStartedLatch != null && this.serverStartedLatch.getCount() > 0L) {
                throw new IllegalStateException("Only one game start await might be in progress");
            }
            this.serverStartedLatch = new CountDownLatch(1);
            return this.serverStartedLatch;
        }

        @Override
        protected void handleInput(String str) {
            super.handleInput(str);
            if (this.serverStartedLatch.getCount() != 0L) {
                Matcher matcher = this.portPattern.matcher(str);
                if (matcher.find()) {
                    this.botsPort = Integer.parseInt(matcher.group(1));
                    this.controlPort = Integer.parseInt(matcher.group(2));
                }
                if ((matcher = this.commandletNotFoundPattern.matcher(str)).find()) {
                    this.exception = new UCCStartException("UDK failed to start due to: Commandlet server not found.", this);
                    this.raiseServerStartedLatch();
                }
                if ((matcher = this.mapNotFoundPattern.matcher(str)).find()) {
                    this.exception = new UCCStartException("UDK failed to start due to: Map not found.", this);
                    this.raiseServerStartedLatch();
                }
                if ((matcher = this.matchStartedPattern.matcher(str)).find()) {
                    this.raiseServerStartedLatch();
                }
            }
        }

        protected void raiseServerStartedLatch() {
            this.timer.cancel();
            this.task.cancel();
            this.serverStartedLatch.countDown();
        }
    }

    protected class StreamSink
    extends Thread {
        protected InputStream os = null;

        public StreamSink(InputStream os) {
            this.setName("UCC Stream handler");
            this.os = os;
        }

        protected void handleInput(String str) {
            if (UCCWrapper.this.uccLog.isLoggable(Level.INFO)) {
                UCCWrapper.this.uccLog.info("ID" + UCCWrapper.this.uccWrapperUID + " " + str);
            }
        }

        @Override
        public void run() {
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.os));
            String s = null;
            try {
                while ((s = stdInput.readLine()) != null) {
                    this.handleInput(s);
                }
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class UCCWrapperConf
    implements Serializable {
        String mapName = null;
        String gameBotsPack = null;
        String gameType = null;
        String options = null;
        Boolean startOnUnusedPort = null;
        String otherCommandLineParameters = null;
        Integer botServerPort = null;
        Integer controlServerPort = null;
        String wineprefix = null;
        transient Logger log = null;
        public static final UCCWrapperConf DEFAULTS = new UCCWrapperConf();

        public void applyDefaults(UCCWrapperConf defaults) {
            if (this.mapName == null) {
                this.setMapName(defaults.mapName);
            }
            if (this.gameBotsPack == null) {
                this.setGameBotsPack(defaults.gameBotsPack);
            }
            if (this.gameType == null) {
                this.setGameType(defaults.gameType);
            }
            if (this.options == null) {
                this.setOptions(defaults.options);
            }
            if (this.startOnUnusedPort == null) {
                this.setStartOnUnusedPort(defaults.startOnUnusedPort);
            }
            if (this.otherCommandLineParameters == null) {
                this.setOtherCommandLineParameters(defaults.otherCommandLineParameters);
            }
            if (this.log == null) {
                this.setLogger(defaults.log);
            }
            if (this.botServerPort == null) {
                this.setBotServerPort(defaults.botServerPort);
            }
            if (this.controlServerPort == null) {
                this.setControlServerPort(defaults.controlServerPort);
            }
            if (this.wineprefix == null) {
                this.setWineprefix(this.wineprefix);
            }
        }

        public UCCWrapperConf setStartOnUnusedPort(boolean startOnUnusedPort) {
            this.startOnUnusedPort = startOnUnusedPort;
            return this;
        }

        public UCCWrapperConf setGameBotsPack(String gameBotsPack) {
            this.gameBotsPack = gameBotsPack;
            return this;
        }

        public UCCWrapperConf setMapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public UCCWrapperConf setGameType(String gameType) {
            this.gameType = gameType;
            return this;
        }

        public UCCWrapperConf setOptions(String options) {
            this.options = options;
            return this;
        }

        public UCCWrapperConf setLogger(Logger log) {
            this.log = log;
            return this;
        }

        public UCCWrapperConf setOtherCommandLineParameters(String otherCommandLineParameters) {
            this.otherCommandLineParameters = otherCommandLineParameters;
            return this;
        }

        public UCCWrapperConf setBotServerPort(Integer botServerPort) {
            this.botServerPort = botServerPort;
            return this;
        }

        public UCCWrapperConf setControlServerPort(Integer controlServerPort) {
            this.controlServerPort = controlServerPort;
            return this;
        }

        public UCCWrapperConf setWineprefix(String wineprefix) {
            this.wineprefix = wineprefix;
            return this;
        }

        static {
            DEFAULTS.setMapName("DM-Deck").setGameBotsPack("GameBotsUDK").setGameType("BotDeathMatch").setStartOnUnusedPort(true);
        }
    }

    private static class UDKChildProcessVisitor
    implements ProcessVisitor {
        Set<Integer> udkPids = new HashSet<Integer>();

        private UDKChildProcessVisitor() {
        }

        public boolean visit(OsProcess op, int i) {
            if (op.processInfo().getCommand().contains("UDK.exe") || op.processInfo().getName().equals("UDK.exe")) {
                this.udkPids.add(op.processInfo().getPid());
            }
            return false;
        }

        public Set<Integer> getUdkPids() {
            return this.udkPids;
        }
    }
}

