/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.server;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.params.impl.RemoteAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.WaitForAgentStateChange;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateRunning;
import cz.cuni.amis.pogamut.base.agent.utils.AgentKeepAlive;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.ChangeMap;
import cz.cuni.amis.pogamut.udk.factory.guice.remoteagent.UDKServerFactory;
import cz.cuni.amis.pogamut.udk.factory.guice.remoteagent.UDKServerModule;
import cz.cuni.amis.pogamut.udk.server.IUDKServer;
import cz.cuni.amis.pogamut.udk.server.exception.MapChangeException;
import cz.cuni.amis.pogamut.udk.server.exception.UCCStartException;
import cz.cuni.amis.pogamut.udk.utils.PogamutUDKProperty;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper;
import cz.cuni.amis.utils.flag.Flag;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class UDKTest06_UDKServer_ChangeMap_Manual {
    private static final Level LOG_LEVEL = Level.INFO;
    protected static boolean useInternalUcc = !Pogamut.getPlatform().getProperty(PogamutUDKProperty.POGAMUT_UNREAL_TEST_EXT_SERVER.getKey()).equals("true");
    private UCCWrapper uccWrapper;
    IUDKServer server;
    UDKServerFactory factory;

    @Before
    public void startUp() throws UCCStartException {
        if (!useInternalUcc) {
            Assert.fail((String)"Must use internal ucc to be able to start/stop gb2004 server and test AgentKeepAlive.");
        }
        System.out.println("Starting UCC...");
        this.uccWrapper = new UCCWrapper(new UCCWrapper.UCCWrapperConf().setStartOnUnusedPort(false));
    }

    @After
    public void tearDown() {
        if (this.server != null) {
            this.server.kill();
        }
        System.out.println("Stopping UCC...");
        this.uccWrapper.stop();
        System.out.println("Closing PogamutPlatform...");
        Pogamut.getPlatform().close();
    }

    private boolean awaitAgentUp(AbstractAgent agent) {
        System.out.println("Awaiting server up (timeout 60s)...");
        IAgentState state = (IAgentState)new WaitForAgentStateChange((Flag)agent.getState(), IAgentStateRunning.class).await(60000L, TimeUnit.MILLISECONDS);
        return state instanceof IAgentStateRunning;
    }

    private void changeMap(IUDKServer server, String map) {
        if (this.awaitAgentUp((AbstractAgent)server)) {
            System.out.println("Changing map to '" + map + "'...");
            try {
                server.getAct().act((CommandMessage)new ChangeMap().setMapName(map));
                server.stop();
            }
            catch (MapChangeException e) {
                Assert.fail((String)"Map change failed...");
            }
        } else {
            Assert.fail((String)"Failed to connect to GBUDK...");
        }
        for (int i = 0; i < 10; ++i) {
            if (this.awaitAgentUp((AbstractAgent)server)) {
                System.out.println("Server is up and running (" + (i + 1) + " / 10) ...");
                if (map.equalsIgnoreCase(server.getMapName())) {
                    System.out.println("Map changed successfully to '" + map + "'...");
                    return;
                }
                System.out.println("Map not changed, is still '" + server.getMapName() + "' ... sending change map again.");
                try {
                    server.setGameMap(map);
                }
                catch (MapChangeException e) {
                    Assert.fail((String)"Map change failed...");
                }
                server.setAddress(this.uccWrapper.getHost(), this.uccWrapper.getControlPort());
                continue;
            }
            Assert.fail((String)"Failed to connect to GBUDK...");
        }
        Assert.fail((String)("10x reconnected to server and map has not been changed to '" + map + "'..."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test01_ChangeMap() {
        String host = this.uccWrapper.getHost();
        int port = this.uccWrapper.getControlPort();
        this.factory = new UDKServerFactory(new UDKServerModule());
        AgentId agentId = new AgentId("Test-ChangeMap");
        this.server = (IUDKServer)this.factory.newAgent((IAgentParameters)new RemoteAgentParameters().setAgentId((IAgentId)agentId).setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress(host, port)));
        AbstractAgent serverAgent = (AbstractAgent)this.server;
        serverAgent.getLogger().setLevel(LOG_LEVEL);
        serverAgent.getLogger().addDefaultConsoleHandler();
        AgentKeepAlive keepAlive = new AgentKeepAlive((IAgent)this.server, 1000L);
        keepAlive.start();
        if (!this.awaitAgentUp(serverAgent)) {
            Assert.fail((String)"Failed to connect server again.");
        } else {
            System.out.println("Connected...");
        }
        String[] maps = new String[]{"DM-Deck", "DM-Sanctuary"};
        try {
            for (int i = 0; i < maps.length; ++i) {
                System.out.println("Change map test, map " + (i + 1) + " / " + maps.length + "...");
                this.changeMap(this.server, maps[i]);
            }
        }
        finally {
            keepAlive.stop();
            this.server.stop();
        }
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        UDKTest06_UDKServer_ChangeMap_Manual test = new UDKTest06_UDKServer_ChangeMap_Manual();
        test.startUp();
        test.test01_ChangeMap();
        test.tearDown();
    }
}

