package cz.cuni.amis.pogamut.udk.bot.impl.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailed;
import cz.cuni.amis.pogamut.base.communication.command.react.CommandReact;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectFuture;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.TurnTo;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import java.util.logging.Level;

public class SimpleBotTest extends AbstractBotTest {

	private long interleave;
	
	public SimpleBotTest() {
		interleave = 0;
	}

	public SimpleBotTest(long interleaveMillis) {
		this.interleave = interleaveMillis;
	}
	
	@Override
	protected void doTest(UDKBot bot, Logger log) {
		final CountDownLatch commandSentLatch = new CountDownLatch(1); 
		CommandReact<TurnTo> turnToReactionOnce = new CommandReact<TurnTo>(TurnTo.class, bot.getAct()) {
			@Override
			protected void react(TurnTo event) {
				commandSentLatch.countDown();
			}
		};
		
		bot.start();

        WorldObjectFuture<Self> self = new WorldObjectFuture<Self>(bot.getWorldView(), Self.class);
        
        if (self.get(10000, TimeUnit.MILLISECONDS) == null) {
        	bot.kill();
            throw new RuntimeException("Self not present in the WorldView after 10 secs.");
        }
        
        if (bot.getController() instanceof BotTestLogic) {
        	BotTestLogic botLogic = (BotTestLogic)bot.getController();
        	if (!botLogic.getLatch().await(1000, TimeUnit.MILLISECONDS)) {
        		bot.kill();
        		throw new RuntimeException("Self not received by LogicModule after 11 secs, even though Self received by the bot!");
        	}
        }
        
        bot.getAct().act(new TurnTo().setRotation(new Rotation(2000, 2000, 2000)));
        
       	try {
       		if (!commandSentLatch.await(1000, TimeUnit.MILLISECONDS)) {
				throw new RuntimeException("Rotation command not sensed.");
			}
		} catch (InterruptedException e) {
			throw new PogamutInterruptedException(e, this);
		}
		
		bot.stop();
		
		if (bot.getState().getFlag() instanceof IAgentStateFailed) {
			throw new RuntimeException("Bot failed due to previous exceptions.");
		}
		
		if (interleave > 0) {
			if (log.isLoggable(Level.WARNING)) log.warning("Going to sleep for "+ interleave + " ms...");
			try {
				Thread.sleep(interleave);
			} catch (InterruptedException e) {
				throw new PogamutInterruptedException(e, this);
			}
		}
	}
	
}
