/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.communication.messages;

import cz.cuni.amis.utils.maps.HashMapSet;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;

public class ItemType
implements Serializable {
    public static final HashMapSet<Category, ItemType> CATEGORIES = new HashMapSet();
    public static final HashMapSet<Group, ItemType> GROUPS = new HashMapSet();
    private static HashMap<String, ItemType> protos = new HashMap();
    public static final ItemType SHOCK_RIFLE = ItemType.MakePrototype(Category.WEAPON, Group.SHOCK_RIFLE, new String[]{"ShockRifle.WeaponPickup"});
    public static final ItemType SHOCK_RIFLE_AMMO = ItemType.MakePrototype(Category.AMMO, Group.SHOCK_RIFLE, new String[]{"ShockRifleAmmo.AmmoPickup"});
    public static final ItemType LINK_GUN = ItemType.MakePrototype(Category.WEAPON, Group.LINK_GUN, new String[]{"LinkGun.WeaponPickup"});
    public static final ItemType LINK_GUN_AMMO = ItemType.MakePrototype(Category.AMMO, Group.LINK_GUN, new String[]{"LinkGunAmmo.AmmoPickup"});
    public static final ItemType ROCKET_LAUNCHER = ItemType.MakePrototype(Category.WEAPON, Group.ROCKET_LAUNCHER, new String[]{"RocketLauncher.WeaponPickup", "RocketLauncher_Content.WeaponPickup"});
    public static final ItemType ROCKET_LAUNCHER_AMMO = ItemType.MakePrototype(Category.AMMO, Group.ROCKET_LAUNCHER, new String[]{"RocketLauncherAmmo.AmmoPickup", "RocketLauncher_ContentAmmo.AmmoPickup"});
    public static final ItemType HEALTH_PACK = ItemType.MakePrototype(Category.HEALTH, Group.HEALTH, new String[]{"HealthPack.HealthPickup"});
    public static final ItemType HEALTH_VIAL = ItemType.MakePrototype(Category.HEALTH, Group.MINI_HEALTH, new String[]{"HealthVial.HealthPickup"});
    public static final ItemType THIGH_PAD = ItemType.MakePrototype(Category.ARMOR, Group.THIGH_PAD, new String[]{"Thighpad.ArmorPickup"});
    public static final ItemType BASE_ARMOR = ItemType.MakePrototype(Category.ARMOR, Group.BASE_ARMOR, new String[]{"BaseArmor.ArmorPickup"});
    public static final ItemType SHIELD_BELT = ItemType.MakePrototype(Category.ARMOR, Group.SHIELD_BELT, new String[]{"ShieldBelt.ArmorPickup"});
    public static final ItemType UDAMAGE = ItemType.MakePrototype(Category.OTHER, Group.UDAMAGE, new String[]{"UDamage.Pickup"});
    public static final ItemType JUMP_BOOTS = ItemType.MakePrototype(Category.OTHER, Group.JUMP_BOOTS, new String[]{"JumpBoots.Pickup"});
    public static final ItemType WEAPON_LOCKER = ItemType.MakePrototype(Category.OTHER, Group.OTHER, new String[]{"WeaponLocker.LockerPickup"});
    public static final ItemType NONE = ItemType.MakePrototype(Category.OTHER, Group.NONE, new String[]{"None", "NONE", "none"});
    private String name;
    private Category category;
    private Group group;
    private ItemType proto;

    public String toString() {
        return "ItemType[name = " + this.name + ", category = " + (Object)((Object)this.category) + ", group = " + (Object)((Object)this.group) + "]";
    }

    public Category getCategory() {
        return this.category == null ? (this.category = this.getProto().category) : this.category;
    }

    public Group getGroup() {
        return this.group == null ? (this.group = this.getProto().group) : this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemType getProto() {
        if (this.proto != null) {
            return this.proto;
        }
        HashMap<String, ItemType> hashMap = protos;
        synchronized (hashMap) {
            this.proto = protos.get(this.name);
            return this.proto;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof ItemType && this.getProto() == ((ItemType)obj).getProto();
    }

    public int hashCode() {
        return this.getProto().name.hashCode();
    }

    public ItemType(String name) {
        this.name = name;
        this.category = Category.OTHER;
        this.group = Group.OTHER;
        this.proto = this;
    }

    private ItemType(String name, Category category, Group group) {
        this.name = name;
        this.category = category;
        this.group = group;
        this.proto = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemType MakePrototype(Category category, Group group, String[] utNames) {
        ItemType type;
        HashMap<String, ItemType> hashMap = protos;
        synchronized (hashMap) {
            type = new ItemType(utNames[0], category, group);
            for (String utName : utNames) {
                protos.put(utName, type);
            }
            if (category != null) {
                CATEGORIES.get((Object)category).add(type);
            }
            if (group != null) {
                GROUPS.get((Object)group).add(type);
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemType getItemType(String utName) {
        ItemType type;
        HashMap<String, ItemType> hashMap = protos;
        synchronized (hashMap) {
            type = protos.get(utName);
            if (type != null) {
                return type;
            }
            type = new ItemType(utName);
            protos.put(utName, type);
        }
        return type;
    }

    public String getName() {
        return this.name;
    }

    public static enum Group {
        LINK_GUN("LinkGun"),
        SHOCK_RIFLE("ShockRifle"),
        ROCKET_LAUNCHER("RocketLauncher"),
        PHYSICS_GUN("PhysicsGun"),
        HEALTH("HealthKit"),
        MINI_HEALTH("HealthVial"),
        THIGH_PAD("Thighpad"),
        BASE_ARMOR("BaseArmor"),
        SHIELD_BELT("ShieldBelt"),
        JUMP_BOOTS("JumpBoots"),
        UDAMAGE("UDamage"),
        OTHER("Unknown"),
        NONE("None");

        public String name;

        private Group(String name) {
            this.name = name;
        }

        public Set<ItemType> getTypes() {
            return GROUPS.get((Object)this);
        }
    }

    public static enum Category {
        WEAPON("Weapon"),
        AMMO("Ammo"),
        HEALTH("Health"),
        ARMOR("Armor"),
        OTHER("Other");

        public String name;

        private Category(String name) {
            this.name = name;
        }

        public Set<ItemType> getTypes() {
            return CATEGORIES.get((Object)this);
        }
    }
}

