package cz.cuni.amis.pogamut.udk.bot.impl.test;

import java.util.logging.Logger;

import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.udk.agent.params.UDKAgentParameters;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.test.TestContext;

public class BotTestContext extends TestContext {
	
	private static int BOT_NUM = 0;
	
	private static final Object MUTEX = new Object();	

	private IAgentFactory factory;
	private SocketConnectionAddress address;

	public BotTestContext(Logger log, IAgentFactory factory, SocketConnectionAddress address) {
		super(log);
		this.factory = factory;
		NullCheck.check(this.factory, "factory");
		this.address = address;
		NullCheck.check(this.address, "address");
	}
	
	public BotContext newBotContext() {
		int num;
		UDKBot bot;
		synchronized(MUTEX) {
			num = ++BOT_NUM;
			bot = (UDKBot) factory.newAgent(
					new UDKAgentParameters().setAgentId(new AgentId("TestBot" + num)).
					setWorldAddress(address));
		}		
		bot.getLogger().addDefaultConsoleHandler();
		return new BotContext(bot);
	}
	
}
